set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4224',
      '30142301',
      NULL,
      NULL,
      '42004220',
      '23021113',
      '02041311',
      '04234032',
      '43042210',
      '13141030',
      '44301312',
      '42020024',
      '00134023',
      '44000320',
      '30030331',
      '31333210',
      '24133243',
      '42310404',
      '03213034',
      '22202031',
      '41144432',
      '14413402',
      '22123242',
      '42403434',
      '32011333',
      '23031334',
      '33034220',
      '31402430',
      '40110120',
      '14114212',
      NULL,
      '31212242',
      '40320304',
      '43111442',
      '42122020',
      '43214234',
      '22443332',
      '44133031',
      '43113042',
      '21111004',
      NULL,
      '32324100',
      '33120131',
      '24423212',
      '30040244',
      '320',
      '40',
      4.805442,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '431310',
      5,
      NULL,
      ' 4- 5-1987',
      120.746552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.547418,
      41,
      NULL,
      21,
      140.506738,
      NULL,
      ' 8-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.385165,
      NULL,
      NULL,
      4.418694,
      7.769928,
      2,
      ' 5- 1-1976',
      2.589493,
      NULL,
      NULL,
      1.737717,
      3,
      NULL,
      4.659103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-1980',
      NULL,
      47.358472,
      21.225698,
      36.638089,
      70,
      70.539694,
      NULL,
      64.457154,
      56.281721,
      8.999645,
      63.691675,
      5.773401,
      ' 2-24-2003',
      12.843402,
      3.255982,
      4.176853,
      4,
      21.272071,
      115.846102,
      10.227863,
      ' 5-18-1978',
      2,
      NULL,
      ' 2-17-1991',
      NULL,
      1.941027,
      10,
      5.788473,
      NULL,
      0,
      0,
      3.525362,
      NULL,
      86.296360,
      0.131178,
      NULL,
      5,
      4,
      5,
      0,
      0,
      1,
      '10- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      134.997633,
      9,
      '11-13-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1999',
      0.476468,
      ' 7-14-1998',
      0.076255,
      3.249886,
      ' 3-12-2000',
      96,
      96,
      ' 0-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      10,
      ' 9- 5-2000',
      15.424044,
      NULL,
      27.478309,
      ' 0-13-1998',
      0,
      36,
      ' 5-26-1993',
      0.970774,
      14.968800,
      17,
      29,
      NULL,
      2.886571,
      1.521847,
      28.368681,
      ' 8-15-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


