set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0021',
      '03312210',
      '40222042',
      NULL,
      NULL,
      '21022304',
      '31004410',
      '01233402',
      '21342332',
      '22040201',
      NULL,
      '13422101',
      '03032142',
      '11034000',
      '14234403',
      '33333242',
      '22113430',
      '43304212',
      NULL,
      '10231212',
      '23044203',
      NULL,
      '04341443',
      '23332200',
      '13140432',
      '32322232',
      NULL,
      '13034411',
      '22120330',
      '42202121',
      NULL,
      '44444310',
      '33333243',
      '31001011',
      '24340134',
      '43213213',
      '43340023',
      '21340144',
      '10431312',
      '24434144',
      '23410414',
      '04433344',
      '24201320',
      NULL,
      '43111312',
      '330',
      '14',
      24.200505,
      NULL,
      '4033434',
      0.252207,
      43.342337,
      NULL,
      NULL,
      '444132',
      5.737486,
      ' 6- 2-1991',
      ' 4- 6-1982',
      50.249338,
      176.633887,
      17.285116,
      12.486451,
      21.488824,
      NULL,
      23.089482,
      6.940020,
      19,
      5,
      4.477454,
      10,
      15,
      NULL,
      29.177947,
      12,
      16.150444,
      8.769668,
      37,
      NULL,
      32,
      6,
      23.986318,
      6,
      0,
      87,
      NULL,
      NULL,
      22.837962,
      NULL,
      77.375954,
      ' 1-15-1978',
      7.682009,
      NULL,
      0.741103,
      13.406426,
      NULL,
      NULL,
      '11- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      8.799060,
      10.202831,
      NULL,
      9,
      6,
      ' 4-24-1985',
      1,
      1,
      109,
      3,
      0.979875,
      45.055818,
      1,
      1.950678,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-1978',
      66.709049,
      7,
      35.154376,
      12.535314,
      63.893505,
      NULL,
      NULL,
      37.668707,
      60.168108,
      51.126409,
      20,
      45.206263,
      ' 8-15-1988',
      3,
      12,
      25.153022,
      37,
      14.239123,
      54,
      11,
      ' 9-16-1981',
      15,
      5.080964,
      ' 9-28-1983',
      2.095818,
      12.193542,
      NULL,
      20,
      8,
      5.656210,
      0,
      NULL,
      1.230042,
      NULL,
      NULL,
      0,
      NULL,
      5,
      21,
      0.286749,
      1.708117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      ' 8-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-2000',
      26,
      ' 7-20-1977',
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.999079,
      ' 5-25-2002',
      52,
      12,
      15.712434,
      ' 1- 6-2002',
      0.564565,
      247.390668,
      NULL,
      NULL,
      10.107361,
      0.075604,
      45,
      ' 5- 0-1974',
      14,
      0,
      336.627588,
      '11-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


