set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8418200';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2210',
      '23401200',
      '11400040',
      '32022442',
      '30042131',
      '00221001',
      '23424434',
      '31442234',
      '40034314',
      NULL,
      '20202034',
      '10021122',
      '44121141',
      NULL,
      '32312203',
      '03404040',
      '23403144',
      '42300204',
      '03332240',
      '34440124',
      '42224022',
      '10440204',
      '42420320',
      '11211103',
      NULL,
      '44001120',
      '32104322',
      '34100204',
      '22024201',
      '04031231',
      '33203432',
      '43220420',
      NULL,
      '02040103',
      '22111432',
      '13303013',
      '10020342',
      '11400122',
      '41010200',
      '42422411',
      '31300230',
      NULL,
      '14232100',
      '41022410',
      NULL,
      '130',
      '44',
      NULL,
      NULL,
      '3002100',
      0.500312,
      1.799525,
      3,
      NULL,
      '444220',
      0,
      ' 8-19-1978',
      ' 0- 1-1991',
      28.904277,
      NULL,
      29.930873,
      NULL,
      3.926969,
      4.062938,
      63,
      6.919192,
      13.642489,
      7.241675,
      22,
      5,
      NULL,
      0,
      13,
      3,
      11.068951,
      6.819800,
      32,
      12.140764,
      12.180490,
      18.086017,
      NULL,
      7,
      1.892879,
      55,
      122,
      55,
      146,
      NULL,
      118.826544,
      NULL,
      0,
      NULL,
      20.250641,
      17.355247,
      113,
      152.543658,
      NULL,
      1,
      2.990574,
      5,
      0,
      0,
      0.441303,
      3.784352,
      0,
      NULL,
      0.545649,
      3.900675,
      NULL,
      NULL,
      2.283038,
      0.291162,
      1.043913,
      1,
      0.304347,
      1.646482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1985',
      55.603348,
      36,
      NULL,
      10.283723,
      23,
      NULL,
      ' 3-23-1999',
      1,
      NULL,
      154.166018,
      0,
      1,
      34,
      1.153987,
      0.607581,
      NULL,
      NULL,
      0,
      156,
      NULL,
      36,
      60,
      71.239414,
      86.124954,
      36,
      74,
      18,
      64.442379,
      86,
      NULL,
      40,
      65,
      NULL,
      22,
      24,
      15.437338,
      27,
      49.169865,
      62.361878,
      12,
      '11-25-1992',
      7.542475,
      NULL,
      ' 9- 2-2000',
      5,
      NULL,
      6.765056,
      2.685331,
      5.157514,
      5,
      7,
      NULL,
      0.594373,
      46.403960,
      6.392035,
      3.238373,
      11.349724,
      6.126475,
      0.037705,
      0,
      4.982962,
      2.939892,
      ' 6- 9-1984',
      2.920904,
      NULL,
      2,
      ' 3-21-1974',
      89,
      5.580847,
      NULL,
      NULL,
      NULL,
      NULL,
      54.023712,
      ' 4- 2-1997',
      NULL,
      ' 0-25-1980',
      13,
      7,
      NULL,
      65.909194,
      56.718215,
      ' 8-28-1997',
      NULL,
      3.531053,
      NULL,
      NULL,
      0,
      ' 5-13-1991',
      NULL,
      2,
      16,
      NULL,
      23.466636,
      25,
      33.234823,
      ' 1-18-1993',
      NULL,
      113.761510,
      NULL,
      0,
      9,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      61.516138,
      ' 7-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.095581);
commit;
end;
/


