set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9684860';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4430',
      '24401443',
      '11114421',
      NULL,
      '11234002',
      '30341211',
      '10132212',
      '41332412',
      '44030110',
      '04113221',
      '20103044',
      '12021323',
      '02322002',
      '22424111',
      '13332310',
      NULL,
      '02220204',
      '42033043',
      '14413234',
      '22122433',
      '13440414',
      '13243303',
      '32104440',
      '12420443',
      '04301021',
      '13130024',
      '33314130',
      '12422400',
      '40234141',
      '33140414',
      '14312430',
      '32441021',
      '43023102',
      '10042333',
      '01424412',
      '03434104',
      '20023341',
      NULL,
      '44340340',
      '22402333',
      '24241032',
      NULL,
      '43224131',
      '40344311',
      '44343331',
      '214',
      '13',
      23.545118,
      0.499910,
      '3020231',
      3.377342,
      NULL,
      NULL,
      NULL,
      '031420',
      2,
      ' 7- 2-1987',
      ' 4-28-1986',
      NULL,
      24.066660,
      32,
      6.935581,
      8.062751,
      15,
      NULL,
      7,
      16.824535,
      9,
      9.872050,
      6.867585,
      12.924688,
      NULL,
      13,
      1.004586,
      NULL,
      2.098129,
      34.519974,
      21,
      33.423655,
      2.626214,
      70,
      7.664798,
      0.790215,
      NULL,
      139.476154,
      75.936846,
      27.481879,
      NULL,
      70.758844,
      ' 7- 5-1988',
      27.598921,
      37.373353,
      14,
      8,
      112.254757,
      123,
      '10-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      3,
      19,
      40.067428,
      30.809319,
      2,
      ' 4-19-1979',
      0.336080,
      1,
      73.149970,
      2.559359,
      0,
      45.512650,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      29.744520,
      NULL,
      33,
      NULL,
      19.251691,
      58,
      47,
      45.645568,
      10,
      34.351103,
      100,
      ' 6- 2-1979',
      27,
      12,
      2.840883,
      65.297994,
      54,
      55,
      10.541567,
      ' 0-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      134,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      ' 6-18-1991',
      31.180729,
      ' 6- 1-1976',
      8,
      13,
      NULL,
      61.297537,
      15.812763,
      ' 0-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      ' 4-23-1986',
      NULL,
      7.493177,
      3.555260,
      NULL,
      NULL,
      NULL,
      ' 7-13-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


