set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2244',
      '42243343',
      NULL,
      '32343144',
      '32004432',
      '22141214',
      '12114443',
      '40231000',
      '30410144',
      '12402021',
      '31331432',
      '43201230',
      '11222131',
      '34412031',
      NULL,
      NULL,
      '31003010',
      NULL,
      NULL,
      NULL,
      '42234042',
      NULL,
      '30122402',
      '14204014',
      NULL,
      '13110234',
      '31411301',
      '21233034',
      '23240042',
      NULL,
      '03331324',
      '24031331',
      '31444043',
      '12223342',
      '41103112',
      '04302411',
      '21143432',
      '11322030',
      NULL,
      '44300141',
      '34421143',
      NULL,
      '40343320',
      '14231211',
      '04234002',
      '242',
      '20',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      '222334',
      1.908667,
      ' 3-18-2000',
      ' 7- 7-1994',
      21.791817,
      NULL,
      24.471635,
      NULL,
      31,
      25,
      45,
      23,
      30,
      25.797892,
      33,
      2,
      33.755854,
      8.544680,
      31.273782,
      4.237729,
      1,
      8.449939,
      67.011128,
      12,
      28.406953,
      7.088157,
      40,
      13.825817,
      1.984886,
      11.957939,
      149.044923,
      NULL,
      60,
      101,
      98.177952,
      NULL,
      53.044436,
      2,
      20.132355,
      NULL,
      138,
      115,
      ' 2-12-1986',
      NULL,
      6.109542,
      4,
      NULL,
      6,
      1,
      3.000196,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.004110,
      0.248864,
      1,
      0.682449,
      NULL,
      0,
      0.430446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      6,
      13.131062,
      11,
      16,
      NULL,
      '10- 6-1995',
      NULL,
      1.426659,
      174.631743,
      1,
      3,
      101,
      NULL,
      4,
      41,
      NULL,
      NULL,
      NULL,
      '11-10-1977',
      7,
      22.964250,
      NULL,
      47,
      43,
      34,
      26.125409,
      32,
      NULL,
      7,
      4.262589,
      41,
      ' 7-12-1996',
      18.134998,
      NULL,
      5,
      70,
      96.310922,
      97,
      15,
      ' 8- 0-1996',
      29.603575,
      NULL,
      ' 6- 3-1981',
      4.149200,
      18,
      23.403410,
      16,
      25,
      7,
      0,
      NULL,
      0,
      25,
      1,
      NULL,
      27.020198,
      3,
      1.721989,
      1.446761,
      1.826148,
      2.255296,
      '10-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      0.350972,
      '10-25-1987',
      NULL,
      NULL,
      NULL,
      19.210908,
      NULL,
      20.403431,
      ' 2-10-1986',
      1.150676,
      NULL,
      '11- 9-1992',
      15.434182,
      75.449832,
      ' 9-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      25,
      ' 7-23-1997',
      NULL,
      NULL,
      25,
      '11-27-1995',
      0,
      33,
      ' 1-13-1976',
      9,
      11.447248,
      17,
      10,
      ' 1- 4-1974',
      18,
      NULL,
      17,
      '10- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


