set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1244',
      '04122423',
      '34143401',
      '03122000',
      '42030132',
      '42100143',
      '21221204',
      '40433432',
      NULL,
      '20232304',
      '31121241',
      '02104344',
      '04141241',
      '01341011',
      '42302001',
      '13224210',
      '33132013',
      NULL,
      '34231330',
      NULL,
      '31303000',
      '11022100',
      NULL,
      '12222214',
      NULL,
      '43140444',
      '20343200',
      '31414114',
      '42133204',
      '23113103',
      '12220313',
      '03331133',
      '04344024',
      '04434104',
      '21000012',
      '11424020',
      '24410242',
      '42422140',
      '44141244',
      '34132301',
      NULL,
      NULL,
      '30312030',
      '20131443',
      '12424203',
      '210',
      '30',
      4,
      NULL,
      '4024342',
      2,
      17.355703,
      NULL,
      NULL,
      '403333',
      3.754323,
      ' 5- 6-1995',
      '10-29-1986',
      61,
      56.265104,
      NULL,
      4,
      NULL,
      4.375026,
      NULL,
      NULL,
      9.053526,
      4.688946,
      18,
      0.973058,
      39.022239,
      8,
      0,
      11,
      11,
      4.559376,
      NULL,
      15.382299,
      20,
      3.148464,
      17.921131,
      13,
      0,
      NULL,
      2,
      26,
      150.304258,
      7.683923,
      51.800967,
      ' 3- 5-1994',
      NULL,
      54,
      3,
      31.447106,
      37,
      197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.218839,
      NULL,
      5.665600,
      5,
      1,
      NULL,
      NULL,
      0.103841,
      50.804119,
      1,
      1,
      81.670971,
      NULL,
      1.821695,
      19,
      NULL,
      NULL,
      NULL,
      ' 2-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      1.909465,
      NULL,
      113.743422,
      11,
      ' 6-26-1995',
      16.774838,
      12.735552,
      '11-25-1997',
      10,
      29,
      13.223277,
      13.022190,
      6,
      NULL,
      0,
      NULL,
      0.168377,
      132.468949,
      NULL,
      0,
      3,
      24.899214,
      1,
      0.865227,
      2.407133,
      0.650593,
      ' 9-11-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7- 1-1989',
      NULL,
      NULL,
      NULL,
      50.794373,
      ' 0-27-1999',
      NULL,
      ' 8- 7-1984',
      NULL,
      2.233769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.659174,
      34.804240,
      ' 8- 6-1990',
      2.148642,
      NULL,
      NULL,
      NULL,
      27,
      15,
      11,
      ' 1- 7-1984',
      NULL,
      1,
      103.499196,
      ' 5- 8-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


