set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '1',
      '2',
      '2',
      '2',
      '4',
      '1',
      '3',
      '2',
      '3',
      '0',
      NULL,
      '4',
      '2',
      '4',
      '4',
      '1',
      '3',
      NULL,
      '0',
      '1',
      NULL,
      '3',
      '',
      NULL,
      '',
      '1',
      '1',
      '4',
      '3',
      '2',
      '',
      '',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3',
      '0',
      '4',
      '2',
      '3',
      '1',
      '032',
      '24401202',
      0.525076,
      27.471939,
      '4234444',
      3.727207,
      31.895941,
      NULL,
      NULL,
      '413430',
      5,
      ' 2- 4-1976',
      ' 9-20-2001',
      61.012340,
      111.547963,
      NULL,
      0,
      16.486963,
      NULL,
      115.437621,
      26.213616,
      7.699977,
      23.409706,
      4,
      9.046991,
      24,
      17,
      11.680604,
      9,
      26.129569,
      NULL,
      NULL,
      25.869788,
      15.516415,
      0,
      17.892269,
      NULL,
      1.276989,
      130.786574,
      76,
      39,
      95,
      226.977266,
      44,
      ' 0-10-1982',
      25.524662,
      NULL,
      29,
      NULL,
      10.491890,
      235.140285,
      '11-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84.082332,
      13.794376,
      10,
      1.894105,
      6,
      NULL,
      NULL,
      3.335127,
      0.670271,
      6,
      0,
      NULL,
      86.510352,
      1.027706,
      0,
      19,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1985',
      61.000974,
      9.245453,
      NULL,
      39.499974,
      29.672077,
      38.269731,
      39,
      NULL,
      NULL,
      41.586385,
      20,
      27.651937,
      ' 9- 7-1986',
      34.220299,
      NULL,
      NULL,
      NULL,
      NULL,
      111.606960,
      NULL,
      ' 7-18-1982',
      9,
      12.490217,
      ' 7- 1-1997',
      NULL,
      19.403943,
      NULL,
      27,
      4.380689,
      NULL,
      NULL,
      NULL,
      NULL,
      111.642034,
      NULL,
      1.756684,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      '10-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      4.407338,
      ' 6-10-1987',
      NULL,
      NULL,
      NULL,
      19.476691,
      ' 0-29-1999',
      49,
      NULL,
      7.490509,
      11,
      ' 3- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      9.506083,
      '10-21-1985',
      28,
      20.450988,
      0.161446,
      ' 2- 4-1984',
      1,
      14.985891,
      '10-17-1975',
      5,
      42.781891,
      1,
      NULL,
      ' 5- 5-1978',
      NULL,
      0,
      55,
      ' 5-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


