set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2',
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      '3',
      NULL,
      '2',
      '0',
      '3',
      '2',
      '4',
      NULL,
      '3',
      '',
      '0',
      '2',
      '3',
      '0',
      NULL,
      '',
      '',
      '0',
      '0',
      '1',
      NULL,
      '2',
      '2',
      '4',
      '2',
      '2',
      NULL,
      '2',
      '104',
      '10313412',
      63.671679,
      60.261896,
      '3300220',
      0,
      NULL,
      0,
      1,
      '432040',
      3.589204,
      ' 1-13-1997',
      ' 9-24-1975',
      31,
      5,
      33,
      24,
      11,
      11.666035,
      44,
      0.932927,
      35,
      9,
      45,
      20,
      16.802380,
      3.908202,
      NULL,
      7.306866,
      12.347903,
      15.189305,
      55.303393,
      21.586848,
      38.093819,
      10.766704,
      NULL,
      17.768902,
      0.539065,
      156.672875,
      6,
      71,
      57,
      NULL,
      184,
      ' 6- 4-2003',
      41.112516,
      71.672445,
      12.694360,
      2,
      102.487576,
      131.931571,
      '10- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.228300,
      22.684395,
      NULL,
      NULL,
      10.497590,
      10,
      ' 0-17-2001',
      NULL,
      1.824306,
      144,
      0,
      0.211140,
      119,
      2,
      1.937141,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1988',
      46,
      16.089844,
      55.041752,
      60,
      3.006493,
      26,
      4,
      75,
      10,
      30.012530,
      31.628068,
      NULL,
      NULL,
      NULL,
      1.597836,
      22,
      NULL,
      NULL,
      131.879602,
      11.096791,
      '11-27-1986',
      2,
      22.896330,
      ' 2-23-1983',
      NULL,
      27,
      11,
      NULL,
      29.591752,
      15,
      NULL,
      4.450492,
      0,
      8.589692,
      0,
      0,
      NULL,
      1,
      1.355884,
      NULL,
      NULL,
      0.896786,
      ' 9-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      63.062679,
      4.969052,
      ' 0- 9-2001',
      NULL,
      NULL,
      NULL,
      40.764841,
      ' 5-22-1991',
      17.803978,
      ' 1-27-1992',
      10,
      8,
      '11- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      20.294602,
      ' 6- 9-1991',
      35,
      27,
      9.318743,
      ' 4- 7-1993',
      3.344015,
      79.479586,
      ' 0-29-1992',
      6.819346,
      16.495701,
      NULL,
      36.361771,
      ' 0- 3-1980',
      55,
      1.431624,
      17.674667,
      ' 1- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


