set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33110314',
      '44132441',
      '02214103',
      '44402024',
      '03430132',
      '43302402',
      '43231132',
      '31434103',
      '40123101',
      NULL,
      '23013423',
      '01200434',
      '12403313',
      '04044140',
      '21310014',
      '12214422',
      NULL,
      '34212234',
      '44340023',
      '32302024',
      '12121424',
      '04301030',
      NULL,
      NULL,
      '44321233',
      '41024014',
      '11430421',
      NULL,
      NULL,
      '40032112',
      '11243032',
      '44002010',
      NULL,
      '10032104',
      '11144424',
      '42433143',
      '14240043',
      '21202304',
      '13442401',
      '01311101',
      NULL,
      '24331311',
      '42311033',
      '44104022',
      '420',
      '02',
      NULL,
      NULL,
      '1444202',
      NULL,
      0,
      2,
      NULL,
      '410233',
      0.183729,
      ' 7-22-1997',
      ' 5-12-1986',
      NULL,
      NULL,
      45.724286,
      9,
      18,
      19.261331,
      45.405873,
      18,
      11.552194,
      21,
      34.409903,
      1.783667,
      45,
      26.512653,
      28.840822,
      NULL,
      12.533979,
      19,
      43.321519,
      3.112187,
      34,
      9,
      82,
      16,
      1.929465,
      36,
      196,
      118,
      54.273051,
      76.175270,
      NULL,
      ' 9-27-1987',
      NULL,
      29.667932,
      36.288074,
      30,
      NULL,
      NULL,
      ' 4-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      35,
      38,
      22,
      0,
      NULL,
      12,
      NULL,
      7.540574,
      NULL,
      ' 1- 3-1983',
      4,
      3,
      NULL,
      22.802123,
      11,
      7.833527,
      1,
      NULL,
      0,
      157,
      1,
      NULL,
      8.308276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      NULL,
      1,
      72,
      '11-29-1984',
      9.550474,
      12.232578,
      NULL,
      29,
      NULL,
      NULL,
      0.075275,
      NULL,
      ' 2-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      15,
      8,
      2,
      0.473678,
      4,
      NULL,
      1,
      0,
      42,
      0,
      0,
      50.917346,
      NULL,
      0.450613,
      41,
      1,
      NULL,
      74,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.018163,
      NULL,
      NULL,
      0.333347,
      0,
      114,
      1,
      0,
      1.761771,
      54,
      0.593559,
      NULL,
      0.738533,
      NULL,
      NULL,
      NULL,
      NULL,
      5.523204,
      NULL,
      33,
      NULL,
      NULL,
      17,
      NULL,
      5,
      1.506527,
      0,
      2,
      1.782132,
      NULL,
      1.303336,
      0.233673,
      NULL,
      ' 7- 4-1981',
      '11-24-1980',
      ' 8-25-1975',
      ' 9-10-1985',
      ' 7-26-1997',
      ' 6-23-2003',
      ' 7- 5-1987',
      NULL);
commit;
end;
/


