set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211543';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '0',
      '2',
      NULL,
      '1',
      '0',
      '4',
      '4',
      '2',
      NULL,
      '0',
      '2',
      '3',
      '2',
      NULL,
      '0',
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      '1',
      '',
      '2',
      '4',
      '0',
      '2',
      '0',
      NULL,
      '',
      '3',
      '3',
      '2',
      '4',
      '4',
      '0',
      '1',
      NULL,
      '2',
      '4',
      '4',
      '202',
      '04214220',
      NULL,
      31.906854,
      '1440244',
      2,
      1,
      3,
      NULL,
      NULL,
      1.470889,
      NULL,
      ' 7- 0-1995',
      65,
      92,
      NULL,
      9,
      22.829721,
      25.619305,
      21,
      16.840013,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.863860,
      1.709380,
      4,
      14,
      51,
      18.060071,
      51.104057,
      20.264190,
      57.382183,
      NULL,
      1,
      3.319042,
      126,
      93,
      NULL,
      72.334282,
      207,
      NULL,
      NULL,
      53,
      10.035853,
      26,
      119,
      95.334421,
      '10- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.476599,
      0.212268,
      8,
      NULL,
      NULL,
      NULL,
      '10- 5-1990',
      1.293751,
      1,
      NULL,
      0.113365,
      2.310955,
      21,
      0,
      0.588125,
      36,
      NULL,
      NULL,
      NULL,
      ' 7-10-1979',
      21.963312,
      77.328584,
      30,
      29,
      NULL,
      NULL,
      19.125042,
      18,
      41.603256,
      NULL,
      NULL,
      70.861295,
      ' 2-11-1999',
      11.142349,
      0,
      NULL,
      7.209021,
      47.886424,
      29.833235,
      2,
      ' 1-24-2002',
      20.973613,
      NULL,
      ' 5-20-1995',
      14.283865,
      NULL,
      5.624561,
      24.314410,
      18.996287,
      0.507521,
      1.502347,
      9.657921,
      0.033885,
      104.786817,
      NULL,
      1.457754,
      17.696144,
      NULL,
      1,
      0,
      NULL,
      0,
      ' 1-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.666610,
      '10- 7-1981',
      NULL,
      NULL,
      NULL,
      47.284162,
      ' 9-18-1976',
      45,
      '11-16-1979',
      NULL,
      8.213110,
      NULL,
      153,
      98.450384,
      ' 8- 0-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      19.564921,
      ' 9-10-1988',
      NULL,
      NULL,
      40.533009,
      '11-10-1984',
      NULL,
      71.382644,
      ' 9- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


