set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '2',
      '3',
      '3',
      '0',
      '4',
      '4',
      '0',
      '1',
      '0',
      NULL,
      '0',
      '2',
      '1',
      NULL,
      NULL,
      '0',
      '0',
      '2',
      '1',
      '4',
      NULL,
      '3',
      '',
      '2',
      NULL,
      '0',
      '0',
      '2',
      '2',
      NULL,
      '',
      '',
      NULL,
      '4',
      NULL,
      '1',
      NULL,
      '3',
      '3',
      '4',
      '1',
      '0',
      '2',
      '021',
      '30444330',
      39,
      NULL,
      '2301142',
      0.150568,
      0,
      NULL,
      1,
      NULL,
      6,
      '11-22-1977',
      ' 3-16-2001',
      25.062191,
      151,
      13.228638,
      5,
      4.969361,
      NULL,
      5.526057,
      1.784769,
      10.868761,
      NULL,
      12.393360,
      11,
      1,
      NULL,
      6,
      8.031832,
      5.261315,
      4.517200,
      7.820654,
      NULL,
      9.304458,
      5,
      37.889887,
      NULL,
      NULL,
      61,
      72,
      6.525372,
      96,
      NULL,
      45.302528,
      '11-18-1982',
      NULL,
      NULL,
      20,
      14,
      NULL,
      117,
      ' 5-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.100861,
      NULL,
      5,
      7,
      16,
      3.258006,
      ' 7-11-1988',
      NULL,
      1,
      184,
      0,
      1.285732,
      101,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1979',
      3.896875,
      107.505040,
      NULL,
      29,
      43,
      80,
      37,
      42,
      67,
      67.681497,
      27,
      54,
      ' 0-18-1989',
      NULL,
      NULL,
      3,
      35.931530,
      42.657129,
      6,
      2,
      ' 0- 5-1989',
      4.887275,
      NULL,
      ' 6-19-2000',
      2,
      1,
      NULL,
      NULL,
      2,
      1.154003,
      1.459860,
      1.985823,
      1,
      9,
      NULL,
      0.675153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282709,
      NULL,
      14,
      ' 8-26-1992',
      8.255385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 5-14-1988',
      4,
      10.802105,
      4.667000,
      ' 6-20-1984',
      10,
      301.721737,
      '10-16-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      71,
      ' 9- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


