set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3100',
      '01323401',
      '43431413',
      '10010313',
      NULL,
      '04014042',
      '24024113',
      '11001404',
      NULL,
      '44234324',
      '13023021',
      '12111433',
      '40200443',
      '40004233',
      NULL,
      '22200142',
      '30421343',
      '13202041',
      '04042142',
      '13103301',
      '11303343',
      '04011043',
      '40013303',
      '33240314',
      NULL,
      '02101131',
      '24421303',
      '13414333',
      '00403244',
      '04123144',
      '13212132',
      '13441440',
      NULL,
      '31201104',
      NULL,
      '14223011',
      '30012212',
      NULL,
      NULL,
      '14004142',
      '43012023',
      NULL,
      '42421041',
      NULL,
      '43034233',
      '224',
      '12',
      NULL,
      NULL,
      '1121341',
      NULL,
      0,
      1,
      NULL,
      '231201',
      3,
      ' 0-21-1994',
      '10- 9-1979',
      88.918976,
      NULL,
      46,
      12.927672,
      NULL,
      9,
      38.373968,
      NULL,
      NULL,
      NULL,
      7.211277,
      5,
      23,
      12.121829,
      19.134384,
      17,
      NULL,
      8.046971,
      17.522093,
      19,
      22.827349,
      13,
      109,
      10,
      1.572785,
      NULL,
      147,
      6,
      22,
      24.282743,
      81,
      NULL,
      43.474607,
      55,
      NULL,
      24.806396,
      NULL,
      33,
      NULL,
      1,
      0.011836,
      1,
      0.725826,
      9.570578,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.513111,
      0.460841,
      1.335738,
      1,
      1.357283,
      0,
      1.485570,
      1.887450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      NULL,
      2.311857,
      7,
      10,
      NULL,
      1,
      0,
      1.046818,
      1.321564,
      1.408045,
      104,
      1.628099,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      '10- 4-1982',
      40.332559,
      76,
      25,
      11,
      63.853501,
      60.332261,
      60,
      6,
      67.474468,
      NULL,
      83.893431,
      3,
      ' 5- 9-1979',
      5,
      NULL,
      7,
      60,
      52.109510,
      50,
      NULL,
      ' 8- 0-1985',
      2,
      10.221100,
      ' 8- 3-1989',
      NULL,
      13,
      19,
      10.743510,
      16.700490,
      NULL,
      NULL,
      NULL,
      1,
      38.194387,
      1.222263,
      NULL,
      22.547652,
      18,
      1.922921,
      NULL,
      0,
      0,
      '11-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      67.087616,
      NULL,
      ' 8-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1975',
      NULL,
      NULL,
      10.603011,
      6,
      ' 5-15-1994',
      NULL,
      NULL,
      NULL,
      1.171496,
      1.925091,
      ' 8- 9-1998',
      NULL,
      NULL,
      NULL,
      0,
      0,
      9,
      NULL,
      41,
      16,
      NULL,
      ' 9- 7-2000',
      1,
      67,
      NULL,
      5.728136,
      12,
      23.902457,
      NULL,
      '11-23-1994',
      72.923658,
      NULL,
      61,
      ' 2-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


