set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1233',
      '14120110',
      '00204144',
      NULL,
      '43300121',
      '32221200',
      NULL,
      '24012033',
      NULL,
      '11434232',
      NULL,
      '03330302',
      NULL,
      NULL,
      '00404344',
      '22103310',
      '22142433',
      '31232121',
      '44440213',
      '40131023',
      '34332210',
      '20022432',
      '02321011',
      '02024041',
      '14200412',
      NULL,
      '24200434',
      NULL,
      '40141201',
      NULL,
      '02012021',
      '13143413',
      NULL,
      '34432433',
      '43213402',
      '03221423',
      '33121333',
      NULL,
      '12223130',
      '32442141',
      '22401131',
      '02332102',
      NULL,
      '01302041',
      '40020040',
      '010',
      '03',
      20.405028,
      NULL,
      '3322432',
      2.856780,
      13,
      2,
      NULL,
      '332344',
      0.880901,
      ' 1- 7-1983',
      ' 6-18-1980',
      2.659750,
      63.927738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.578064,
      52.824671,
      6.637767,
      25,
      48.680313,
      98,
      ' 2- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.651175,
      9,
      0.819718,
      NULL,
      0,
      ' 8-16-1974',
      0.101382,
      2.232212,
      65,
      0.042990,
      1.893559,
      113.302561,
      3.495277,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      36,
      NULL,
      4.189695,
      5.934331,
      NULL,
      NULL,
      72.827539,
      20,
      45,
      NULL,
      '11-27-2003',
      NULL,
      1,
      10,
      NULL,
      62.904671,
      12,
      5.308053,
      '10- 2-1983',
      NULL,
      10,
      ' 6-23-2003',
      2.731642,
      1,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      6.463578,
      0.887597,
      0,
      0,
      0.508283,
      NULL,
      28.249544,
      0.930757,
      NULL,
      0,
      0,
      ' 8- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      34.305619,
      ' 9-22-1982',
      NULL,
      NULL,
      NULL,
      11,
      ' 4- 3-2002',
      52,
      59,
      '11-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      13.019583,
      ' 4- 8-1994',
      55,
      13,
      56,
      ' 7-22-1999',
      1,
      60,
      ' 9-25-1976',
      1,
      25,
      12.711801,
      37,
      ' 7- 9-1977',
      36,
      0,
      83.892685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


