set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1143',
      NULL,
      '21200023',
      '32310303',
      '23321433',
      '20142321',
      '33042002',
      '14242420',
      '42412242',
      NULL,
      '13412044',
      '14001043',
      '00124203',
      '41213333',
      '04224210',
      '01202002',
      '23143124',
      '44422122',
      '43223314',
      '33312334',
      '12312202',
      NULL,
      '30113201',
      '34434114',
      '23022033',
      '30134404',
      NULL,
      '44131424',
      '11024421',
      '32313034',
      '10114130',
      '13111200',
      '40340311',
      '12134014',
      '22131404',
      '24414112',
      NULL,
      NULL,
      '40112210',
      '02401200',
      '04422124',
      '03302113',
      '02211120',
      '44300342',
      '44122043',
      '041',
      '23',
      NULL,
      NULL,
      '4422123',
      2.576637,
      1.548453,
      2,
      NULL,
      NULL,
      0,
      ' 0-19-1979',
      ' 2-13-1999',
      11.355594,
      NULL,
      8.107816,
      1,
      14,
      8,
      14.247025,
      NULL,
      6.605253,
      8,
      27,
      11.228525,
      12,
      4,
      34,
      6.970683,
      19.704463,
      10.739683,
      NULL,
      16.884028,
      NULL,
      9,
      42,
      13.165917,
      0.219915,
      63,
      131,
      73,
      63.081986,
      113.983242,
      NULL,
      ' 9- 4-1990',
      NULL,
      42,
      28.799582,
      NULL,
      NULL,
      203.251628,
      '10- 3-1977',
      NULL,
      3.528301,
      2,
      0.686176,
      4,
      NULL,
      1.504368,
      1.289451,
      0,
      1,
      2.177443,
      0,
      1,
      0,
      0.885510,
      1,
      0,
      0.345680,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      11.796021,
      8,
      8,
      5.499988,
      ' 0-19-1989',
      1.884477,
      1,
      100,
      1.001271,
      10.851072,
      4,
      NULL,
      5,
      7.928157,
      1,
      NULL,
      62,
      NULL,
      46,
      NULL,
      91.939707,
      NULL,
      117,
      118.484694,
      94,
      74,
      46,
      40,
      100.597691,
      85,
      ' 0- 8-1975',
      13,
      10.556179,
      19.756553,
      43.511148,
      NULL,
      3,
      NULL,
      ' 4- 6-1994',
      NULL,
      19.990147,
      ' 0-19-1985',
      NULL,
      7,
      5.837698,
      NULL,
      19,
      4,
      1.932384,
      2.118075,
      0.425571,
      21,
      1.789013,
      3,
      NULL,
      12.290944,
      1.455530,
      0.818574,
      0,
      1.926123,
      ' 4- 7-2000',
      NULL,
      3.796370,
      4,
      NULL,
      NULL,
      NULL,
      ' 7-12-1976',
      NULL,
      NULL,
      NULL,
      47.291044,
      ' 0-15-1984',
      33.646420,
      ' 6-10-1978',
      NULL,
      14.499209,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      ' 6- 5-1979',
      8.352184,
      7.706865,
      ' 7-11-1982',
      0,
      1,
      22,
      ' 2-28-1995',
      38,
      15,
      0.138324,
      ' 1- 0-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.264856);
commit;
end;
/


