set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4234',
      '20142041',
      NULL,
      '42243331',
      '10203244',
      '03021300',
      '42024404',
      '44104020',
      '14123420',
      '10033404',
      '01311301',
      '01021233',
      '24124110',
      '13231223',
      '00124032',
      '11330421',
      '32010114',
      '23220304',
      '24101440',
      '22434130',
      '13330104',
      '11444344',
      '43300102',
      NULL,
      '32140000',
      '00344332',
      '33103233',
      '30403321',
      '14012241',
      '42434044',
      '42022132',
      NULL,
      '12242342',
      '23142420',
      '44423241',
      NULL,
      '42034433',
      NULL,
      '10134300',
      '11424220',
      '22133120',
      NULL,
      '30424430',
      '32244214',
      '32112333',
      NULL,
      '',
      NULL,
      NULL,
      '4021324',
      1.825845,
      0,
      2,
      NULL,
      '002203',
      1.036654,
      ' 8- 3-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      10.633619,
      NULL,
      53,
      NULL,
      NULL,
      10.696690,
      7,
      15,
      16.675875,
      NULL,
      14,
      5.336902,
      9.101355,
      1.857044,
      1.252042,
      NULL,
      0,
      NULL,
      18.991652,
      9.095331,
      NULL,
      28,
      135.362042,
      25,
      11.394937,
      38,
      3,
      '11-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630469,
      NULL,
      9,
      20.079528,
      24.757536,
      NULL,
      3.443064,
      ' 8-25-1990',
      6.282454,
      0.861794,
      '10-24-1985',
      6.956180,
      6.073426,
      11,
      11,
      1.939077,
      4,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      0,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      18,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      65.259111,
      3,
      4.598297,
      ' 2-20-1978',
      60.367557,
      1.700909,
      NULL,
      '11-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.347463,
      1,
      98.900230,
      15,
      73.464286,
      10.690187,
      NULL,
      44,
      1,
      NULL,
      27.289175,
      NULL,
      NULL,
      NULL,
      1,
      4,
      168.124834,
      2.076575,
      2,
      NULL,
      9.687488,
      13.403004,
      18.729246,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      16.614018,
      NULL,
      45,
      1.758477,
      NULL,
      32.441164,
      1.100639,
      0.834458,
      1,
      0.593668,
      4,
      1,
      2,
      NULL,
      2.969652,
      0.761624,
      45.158607,
      NULL,
      0.654132,
      24.034370,
      14,
      0.554269,
      7.163494,
      NULL,
      34,
      7.018781,
      NULL,
      1,
      28,
      3,
      0.154567,
      3,
      0.258170,
      0,
      4,
      37,
      NULL,
      NULL,
      ' 0- 1-1981',
      NULL,
      ' 9- 8-1986',
      ' 3-12-1986',
      ' 7- 0-1980',
      NULL);
commit;
end;
/


