set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7838975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '2',
      '4',
      '2',
      '3',
      NULL,
      '1',
      '4',
      '4',
      '2',
      '0',
      '2',
      '4',
      '1',
      '1',
      '1',
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      '',
      '3',
      '',
      '0',
      '0',
      NULL,
      '1',
      '3',
      '',
      '',
      '2',
      '1',
      NULL,
      '3',
      '2',
      '2',
      '4',
      NULL,
      NULL,
      '0',
      '4',
      '310',
      '31303444',
      85.808868,
      64.246295,
      '1440303',
      2.913736,
      1,
      0,
      0,
      '111220',
      4,
      ' 6-28-1991',
      '10- 7-1996',
      30.977430,
      NULL,
      38.566488,
      12.225026,
      7,
      11,
      NULL,
      9,
      10,
      9.883918,
      NULL,
      13,
      14,
      18,
      NULL,
      10.070883,
      18,
      6,
      22,
      14,
      43,
      10,
      85,
      1.087489,
      0,
      39.488847,
      24.074347,
      3.209912,
      92,
      169,
      31.530662,
      '11-25-1986',
      10.357850,
      NULL,
      21.238319,
      NULL,
      128,
      82.971116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      44.427553,
      15,
      28.278311,
      NULL,
      ' 1-13-1995',
      NULL,
      1,
      119,
      NULL,
      1.226369,
      120.409579,
      NULL,
      0.738935,
      40,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1982',
      102,
      NULL,
      77.269850,
      62.251402,
      36,
      29.100435,
      21.173884,
      39.504325,
      NULL,
      18,
      67.231544,
      NULL,
      ' 9-18-1997',
      4.795402,
      16.487134,
      2.314075,
      75,
      22.837310,
      NULL,
      3.996073,
      NULL,
      4.184511,
      2.154469,
      ' 1-29-1993',
      10,
      4.797410,
      4,
      11,
      7,
      NULL,
      0.708754,
      NULL,
      0,
      8,
      1,
      0.036661,
      1.303869,
      12,
      3,
      7.457038,
      0.690465,
      1.286430,
      ' 8-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      112.265444,
      3,
      ' 0- 8-1993',
      NULL,
      NULL,
      NULL,
      45.693655,
      ' 5-15-1985',
      NULL,
      ' 5-20-1990',
      13.733707,
      NULL,
      NULL,
      NULL,
      12,
      ' 0-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      17.873993,
      ' 9-28-2002',
      45,
      9,
      5,
      ' 1-19-1987',
      0,
      64,
      ' 1- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


