set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3441',
      '42411431',
      '40112443',
      '12334044',
      '13410411',
      '34242243',
      '02243443',
      '33322310',
      '22043200',
      '40411211',
      '04322114',
      '03032440',
      '24204432',
      '20213401',
      '24232404',
      '34230011',
      NULL,
      '33423043',
      '00020234',
      NULL,
      NULL,
      NULL,
      NULL,
      '11243422',
      '20040102',
      '23320232',
      '40232432',
      '40234032',
      NULL,
      '13032403',
      '23411030',
      '24023402',
      '34314310',
      '03111333',
      '31314312',
      '42433323',
      '33132031',
      '30002403',
      '40134102',
      '04030143',
      '13231034',
      NULL,
      NULL,
      '03343324',
      '03144321',
      '204',
      '42',
      NULL,
      NULL,
      '2034214',
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      ' 4-16-1994',
      ' 1-25-1984',
      NULL,
      NULL,
      7,
      16,
      3.730317,
      4,
      NULL,
      7.817815,
      1.644665,
      14.401705,
      14.350563,
      7.525003,
      16,
      3.708722,
      1.285983,
      1.050167,
      22,
      17,
      43,
      15,
      NULL,
      3,
      21,
      4,
      1,
      96,
      77.269194,
      37,
      NULL,
      NULL,
      NULL,
      '10-22-1977',
      52.331292,
      49,
      3,
      23.948631,
      118.472918,
      30.504585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.833622,
      20.955186,
      0.008342,
      4.890050,
      2,
      0,
      ' 6- 4-1981',
      NULL,
      NULL,
      112,
      1,
      5,
      NULL,
      4.270793,
      1,
      86.340949,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1975',
      105.953796,
      56,
      92,
      55,
      15,
      23.300654,
      41,
      76.690225,
      75.663095,
      6.486020,
      57,
      51,
      ' 2- 8-1980',
      NULL,
      23.297254,
      8,
      56,
      47,
      60,
      11.344617,
      ' 6- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.076936,
      '11- 6-1992',
      28.755007,
      ' 5- 7-1994',
      NULL,
      NULL,
      ' 6- 7-1980',
      133,
      12,
      ' 2-23-1974',
      NULL,
      9.058431,
      ' 7-21-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 1-20-1990',
      20.571684,
      27,
      2.059822,
      '10-22-1998',
      NULL,
      94,
      ' 0-15-1997',
      17.408099,
      10,
      14,
      14,
      ' 0-10-1985',
      53,
      NULL,
      11.476502,
      ' 3-20-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


