set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9406956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '0',
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '4',
      '3',
      '0',
      NULL,
      '2',
      '1',
      '4',
      NULL,
      '3',
      '3',
      NULL,
      '0',
      '0',
      '3',
      '3',
      '1',
      '',
      '1',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '2',
      '',
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      '2',
      '1',
      '4',
      '3',
      '0',
      '3',
      '3',
      '444',
      '21210322',
      62.433194,
      2,
      NULL,
      2.790725,
      1,
      0,
      1,
      '031122',
      3.853344,
      NULL,
      NULL,
      NULL,
      90,
      NULL,
      0,
      0.344786,
      NULL,
      56.713739,
      17.514198,
      NULL,
      9,
      19,
      NULL,
      19.744144,
      14.007101,
      9.497243,
      12,
      15,
      25,
      38,
      9.981042,
      0.969432,
      13.159199,
      97,
      12.612327,
      1,
      109.700055,
      87,
      75.835614,
      125.971348,
      13,
      29.093577,
      ' 8- 6-1994',
      30.192659,
      NULL,
      NULL,
      35,
      198.917087,
      172,
      ' 7- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.257190,
      NULL,
      NULL,
      5.096639,
      NULL,
      9.969935,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681053,
      0,
      141.885444,
      NULL,
      1.670909,
      13.807743,
      NULL,
      NULL,
      NULL,
      ' 2-13-1978',
      15.467035,
      86,
      71,
      62,
      52,
      104.128760,
      74.975295,
      60.637371,
      NULL,
      22,
      26,
      NULL,
      ' 8-15-1990',
      23,
      NULL,
      4.197480,
      20,
      119,
      90.926741,
      10,
      ' 9- 4-1998',
      37.778946,
      36.260402,
      ' 6- 0-1980',
      NULL,
      2.574300,
      6.160541,
      12.892920,
      NULL,
      2,
      NULL,
      11,
      0.891746,
      NULL,
      1,
      NULL,
      10,
      3,
      1.108463,
      NULL,
      0,
      0.431260,
      ' 9-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      9,
      ' 9-16-2003',
      NULL,
      NULL,
      NULL,
      9.316784,
      ' 0-10-1975',
      NULL,
      ' 6- 7-1993',
      11,
      NULL,
      ' 5-23-1982',
      78.664989,
      NULL,
      ' 5-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      15.925344,
      '10- 1-1989',
      36,
      NULL,
      2,
      ' 6- 2-1980',
      2.978254,
      69.308417,
      ' 0-21-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


