set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9797025';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      '3',
      '0',
      '0',
      '4',
      '0',
      '3',
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4',
      NULL,
      '1',
      '2',
      '1',
      '2',
      '1',
      '3',
      '4',
      '0',
      '',
      '2',
      '',
      '2',
      '2',
      '0',
      NULL,
      '1',
      NULL,
      '',
      '2',
      '2',
      NULL,
      '2',
      '0',
      '3',
      '3',
      '4',
      '1',
      '1',
      '4',
      NULL,
      '42203042',
      0,
      53.145577,
      '2333201',
      0.879501,
      1.740271,
      2,
      NULL,
      '114113',
      5.244963,
      '11-20-1980',
      ' 4-16-2000',
      69,
      223,
      18,
      11,
      29.654016,
      NULL,
      28,
      15.383091,
      3,
      20.130973,
      NULL,
      6,
      36,
      NULL,
      6.017411,
      NULL,
      5.413462,
      6,
      62.636674,
      14,
      32,
      18,
      56,
      1,
      NULL,
      112.786339,
      NULL,
      6,
      161.271121,
      NULL,
      149.389740,
      '10- 0-1983',
      30,
      27.258745,
      2,
      5,
      NULL,
      136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.716758,
      3.530782,
      6,
      4,
      15.144299,
      5,
      ' 0-10-1978',
      0.186040,
      NULL,
      181.322245,
      1.866513,
      1.651761,
      48,
      1,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1994',
      107,
      95.436512,
      2,
      38.292678,
      50.945769,
      55,
      6.812625,
      58,
      16.763751,
      1,
      34.568455,
      22,
      NULL,
      12.744228,
      9.914676,
      9,
      25,
      22,
      5.031625,
      8,
      ' 1-29-1974',
      15.674465,
      8.583260,
      ' 2-15-2003',
      14,
      9.609067,
      10.778710,
      7.245377,
      7.329402,
      8,
      1,
      NULL,
      2.934372,
      28,
      1,
      1,
      NULL,
      1,
      2.494085,
      2,
      0,
      0,
      ' 9-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      97.312754,
      27.625695,
      ' 7-22-1990',
      NULL,
      NULL,
      NULL,
      41,
      ' 7- 0-1979',
      17.885117,
      NULL,
      7,
      0,
      ' 9-29-1996',
      101,
      NULL,
      ' 8-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      6.866984,
      ' 2- 2-1984',
      62,
      NULL,
      50.842295,
      ' 6-15-1993',
      0,
      18,
      ' 4- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


