set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9536816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '0',
      NULL,
      '0',
      '0',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      '1',
      '1',
      '1',
      '3',
      '2',
      '',
      '0',
      '',
      '0',
      '0',
      '2',
      '4',
      NULL,
      '',
      '',
      '1',
      '2',
      NULL,
      NULL,
      '2',
      '2',
      '3',
      '1',
      '1',
      NULL,
      NULL,
      '422',
      '00240011',
      47,
      33,
      '2432220',
      2.168038,
      0,
      1,
      NULL,
      NULL,
      2.439912,
      NULL,
      ' 0- 4-1977',
      NULL,
      95,
      9.860250,
      14.135565,
      NULL,
      8.155559,
      13,
      3.330588,
      NULL,
      13,
      5,
      NULL,
      13.679153,
      NULL,
      13,
      0.301949,
      1.821055,
      11.805370,
      NULL,
      11,
      36.097591,
      8,
      147.577610,
      NULL,
      1,
      65,
      200,
      95.591571,
      148.247901,
      NULL,
      233.575542,
      ' 8-13-1979',
      42.628723,
      NULL,
      21,
      28.647159,
      208.957400,
      242.571524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.250724,
      15.456733,
      1,
      0.669559,
      9,
      5,
      ' 4-25-1976',
      1.665409,
      1.322850,
      32.337226,
      1,
      0,
      135.867211,
      1.889270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1990',
      81.034841,
      42.338576,
      57.045053,
      95.035309,
      93,
      90,
      NULL,
      72,
      57,
      NULL,
      100,
      4,
      ' 3- 4-1988',
      7,
      9.479691,
      3,
      91,
      48,
      11.462017,
      15.549123,
      ' 8-25-1999',
      5.947204,
      17.411382,
      ' 0-26-2002',
      2.721198,
      NULL,
      11,
      NULL,
      NULL,
      7,
      1,
      8.844435,
      1.023791,
      66.929582,
      3,
      0.414343,
      NULL,
      NULL,
      1.186339,
      0,
      1.637971,
      0.006845,
      ' 6-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-29-1992',
      NULL,
      NULL,
      NULL,
      6,
      ' 7-13-1975',
      46.285232,
      ' 5-14-1981',
      7.345196,
      18.880485,
      ' 0-11-1992',
      88,
      13.883806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      23.549662,
      '10-28-1990',
      3.163184,
      NULL,
      14.125022,
      NULL,
      0,
      37.303024,
      '11- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


