set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0440',
      '23410241',
      '30424033',
      '24044114',
      NULL,
      '12022313',
      '00330314',
      '43224443',
      '03423000',
      '32303203',
      '13341234',
      '40433323',
      '20014122',
      '44414340',
      NULL,
      '31042223',
      NULL,
      '30304012',
      '34013443',
      '30000021',
      '34023112',
      '03442424',
      NULL,
      '11333210',
      '42420324',
      '01004103',
      '30123333',
      '40144424',
      '32020224',
      NULL,
      '44332132',
      '42141012',
      '02210003',
      '21011003',
      '30020330',
      NULL,
      '13131013',
      '44113443',
      '20321044',
      '32123031',
      '01223121',
      '13223002',
      NULL,
      '41102031',
      '13311431',
      '',
      '',
      NULL,
      NULL,
      '0332044',
      2,
      1,
      1,
      NULL,
      '003310',
      0.365904,
      ' 4-29-1976',
      ' 1- 5-1999',
      10,
      NULL,
      NULL,
      6,
      6.428029,
      13,
      61.256933,
      13.406649,
      13.087146,
      2,
      2.785810,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      6.467424,
      8.707713,
      NULL,
      9,
      7,
      NULL,
      6.130058,
      6.580190,
      NULL,
      29.395812,
      14.689979,
      NULL,
      NULL,
      NULL,
      97.890515,
      ' 6- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.693203,
      3.350067,
      NULL,
      NULL,
      4.934637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-2002',
      49,
      9,
      45,
      NULL,
      NULL,
      79.276314,
      NULL,
      31,
      77,
      NULL,
      81,
      39.132017,
      ' 0-28-1986',
      18,
      12.770148,
      6.660671,
      53.814981,
      26.456087,
      118.513756,
      11,
      ' 2- 6-2002',
      16.141950,
      8.753676,
      '11-17-1983',
      NULL,
      5.974949,
      4.308765,
      9,
      17.900556,
      3.557045,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.291947,
      7.833193,
      4,
      ' 3-14-1995',
      NULL,
      0.124107,
      NULL,
      5.129488,
      43,
      NULL,
      120.891130,
      ' 0-17-1982',
      46.557039,
      1.420434,
      308.546671,
      ' 0-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      88.065531,
      38.487530,
      6,
      48.245142,
      96,
      22.881472,
      NULL,
      7,
      NULL,
      2.761102,
      40.753237,
      2,
      0,
      95,
      2.974328,
      1,
      66,
      1.607916,
      NULL,
      46,
      2,
      8.925342,
      247,
      40,
      13,
      NULL,
      NULL,
      38,
      0,
      1,
      0.004757,
      3,
      0,
      0,
      50,
      NULL,
      0.146477,
      5.581183,
      80.841895,
      NULL,
      1.213303,
      14.911598,
      35.862513,
      1.074769,
      8,
      3.448751,
      7,
      1.774842,
      NULL,
      3.243984,
      NULL,
      NULL,
      0.311603,
      47.228837,
      21,
      6.362230,
      3,
      33.557587,
      NULL,
      17.063086,
      NULL,
      1.830576,
      2.618573,
      0,
      15.307833,
      1,
      NULL,
      NULL,
      0.304377,
      63.319633,
      '11- 5-1986',
      ' 9- 4-1983',
      '11- 4-1995',
      ' 4-28-1974',
      ' 3-25-1995',
      ' 2- 8-1975',
      ' 1- 0-1996',
      NULL);
commit;
end;
/


