set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4401',
      NULL,
      '21130421',
      '04024323',
      '03340414',
      NULL,
      '31021241',
      '21014221',
      '14221242',
      NULL,
      '23010423',
      '12243403',
      '03012042',
      NULL,
      '33011324',
      '12021431',
      '43410334',
      '01211220',
      '14224112',
      NULL,
      '21404312',
      '42324014',
      '23132400',
      '40000430',
      NULL,
      '41004131',
      '42144032',
      '43430203',
      '34010014',
      '01120013',
      '42003003',
      '42032432',
      '20201044',
      '33311422',
      '10234142',
      '02420231',
      '13214114',
      '01100314',
      '31321240',
      '22122342',
      '44332040',
      '21131222',
      '11341002',
      NULL,
      '12120420',
      '433',
      '23',
      NULL,
      NULL,
      '2133044',
      2.641634,
      31.267721,
      0,
      NULL,
      '414424',
      NULL,
      ' 3-12-2002',
      NULL,
      36,
      NULL,
      NULL,
      19,
      19,
      18,
      4,
      13,
      NULL,
      12,
      6.915307,
      7,
      NULL,
      NULL,
      31,
      NULL,
      36,
      NULL,
      4.487534,
      6.735590,
      16,
      11,
      10.864175,
      7,
      0,
      61,
      119.665552,
      24,
      97,
      74,
      99.777769,
      ' 0- 9-2003',
      NULL,
      7.255913,
      20.620473,
      16,
      41,
      13,
      '11-22-1990',
      0.017221,
      5,
      2,
      NULL,
      1.306162,
      NULL,
      0,
      4,
      4,
      1.303892,
      2.953253,
      1.297533,
      2,
      2.468585,
      0,
      0.254903,
      0.549529,
      1.409640,
      0.837563,
      8.298845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      21,
      3,
      23,
      6.248619,
      2,
      ' 8- 2-1994',
      1,
      0,
      156,
      NULL,
      2,
      26.856188,
      2,
      6.878092,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      NULL,
      76,
      57,
      15.769308,
      NULL,
      40,
      75.743606,
      16.264668,
      52.567423,
      23,
      NULL,
      '10-18-1991',
      10.034001,
      NULL,
      18,
      NULL,
      39,
      NULL,
      6,
      ' 9-24-1997',
      1,
      10.005891,
      NULL,
      11,
      NULL,
      0,
      8.827287,
      3,
      7.841438,
      2,
      14.466363,
      1.849816,
      17.966318,
      1.902224,
      NULL,
      8,
      10.508256,
      9.609745,
      1.479277,
      NULL,
      0.094776,
      NULL,
      NULL,
      0,
      4,
      ' 8-14-1998',
      1,
      14.070992,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      18,
      ' 1-27-2002',
      8.329506,
      7.125396,
      ' 8- 4-1980',
      75.920306,
      NULL,
      NULL,
      5.068993,
      0.599306,
      '10- 6-1988',
      NULL,
      NULL,
      NULL,
      2,
      1,
      13.949260,
      ' 2- 3-2000',
      32.037375,
      NULL,
      17,
      ' 7-12-1986',
      1.331035,
      NULL,
      '11-18-1984',
      7.723038,
      30.572455,
      13,
      31,
      ' 4-24-1983',
      21,
      NULL,
      40.845331,
      ' 8-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


