set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '0',
      NULL,
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '2',
      '3',
      '1',
      '1',
      '0',
      '2',
      NULL,
      '4',
      '0',
      '3',
      '2',
      '',
      '0',
      '',
      '2',
      '1',
      '1',
      '0',
      '0',
      '',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      NULL,
      '2',
      '1',
      '4',
      '0',
      '4',
      NULL,
      '330',
      '33212201',
      17,
      17.520878,
      NULL,
      NULL,
      215.493889,
      3,
      NULL,
      '111231',
      5,
      ' 1- 8-1993',
      ' 8-24-1994',
      26,
      111,
      23.981997,
      1,
      6.598559,
      13,
      20.044381,
      4,
      6,
      7.183381,
      13,
      5.805697,
      12.231381,
      0.040009,
      7,
      8,
      NULL,
      2,
      1,
      5,
      23.468456,
      11.420749,
      7.148297,
      4.388569,
      NULL,
      47,
      146,
      1.761919,
      NULL,
      NULL,
      84.320371,
      '11- 6-1985',
      NULL,
      15,
      13.586881,
      16.661308,
      55,
      5.355492,
      ' 4- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      48,
      3,
      31,
      20.209299,
      NULL,
      ' 1- 4-1984',
      1,
      0.148975,
      7,
      0.506583,
      1,
      57.831290,
      1,
      1,
      28,
      NULL,
      NULL,
      NULL,
      ' 6-21-1994',
      22.191073,
      3.980457,
      35.562192,
      7,
      NULL,
      1.490146,
      NULL,
      0,
      20,
      11,
      1.065720,
      19,
      ' 2- 2-1974',
      17,
      0.878759,
      NULL,
      NULL,
      51,
      39,
      6.848839,
      ' 9-21-1978',
      7.008752,
      14.187289,
      ' 7- 4-1995',
      6.589876,
      12.548458,
      9,
      12.700951,
      12,
      4,
      0.117573,
      0,
      0.365771,
      44.786411,
      3.605404,
      1.636508,
      2,
      21.371966,
      1,
      1,
      NULL,
      0,
      ' 8- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.366712,
      ' 6-14-1979',
      4,
      ' 0- 4-1975',
      9.409191,
      1.202566,
      ' 3- 2-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      14,
      NULL,
      NULL,
      6.624515,
      9.041064,
      ' 6-18-1980',
      NULL,
      229.523956,
      ' 6-23-1987',
      11.013665,
      11,
      6,
      70,
      NULL,
      2.504959,
      0.631235,
      129.580805,
      ' 4-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


