set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '0',
      '4',
      '1',
      NULL,
      '2',
      '2',
      '1',
      '4',
      '1',
      '2',
      NULL,
      '4',
      '4',
      '1',
      '0',
      NULL,
      '4',
      '3',
      '1',
      '4',
      NULL,
      '1',
      '',
      '3',
      '',
      '0',
      '4',
      NULL,
      '3',
      '4',
      '',
      '',
      '3',
      '3',
      '0',
      '0',
      '3',
      NULL,
      '3',
      '3',
      '3',
      '0',
      '1',
      '414',
      '11414303',
      57.508866,
      3,
      '1314312',
      3.800223,
      NULL,
      1,
      1,
      '312223',
      5,
      ' 8-11-1988',
      ' 7-14-1997',
      67.036915,
      178.224006,
      7.284852,
      3.293082,
      4,
      5,
      39.545347,
      8,
      4.626697,
      10,
      21.702185,
      NULL,
      9.802431,
      3.553740,
      7.163178,
      4,
      4.298152,
      3,
      21.844723,
      5,
      34,
      1,
      77.579255,
      0,
      1,
      39,
      123,
      14,
      53.909536,
      51,
      117,
      ' 8-18-1999',
      3.415345,
      23,
      21,
      2.295203,
      26,
      NULL,
      ' 1-20-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      8.272053,
      27,
      15.861638,
      29,
      1,
      ' 3-24-1999',
      0.094147,
      1,
      NULL,
      0,
      1,
      30,
      0,
      0,
      69.844751,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1982',
      77.340509,
      NULL,
      51,
      22,
      69,
      57,
      80,
      55,
      38.204382,
      26,
      48,
      14,
      '11- 3-1983',
      23.364721,
      2,
      10.200519,
      NULL,
      28.800147,
      78.023117,
      3,
      '11- 1-1990',
      6.242070,
      0,
      '10-22-1986',
      1,
      2,
      1,
      9.929787,
      6,
      7,
      1,
      7,
      1,
      NULL,
      1.921520,
      NULL,
      7.004346,
      16.602508,
      0.240603,
      5,
      NULL,
      1.814358,
      ' 1- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 7-15-1980',
      21.320506,
      ' 5-23-1988',
      11.164617,
      0,
      '10-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6.393872,
      '11-14-1983',
      NULL,
      0.028067,
      9,
      ' 8-25-1979',
      3,
      173,
      ' 1-24-1993',
      13,
      95,
      6,
      72.355875,
      ' 3- 5-2002',
      39,
      3,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


