set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9216091';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2323',
      '41000003',
      '20201303',
      '34030021',
      '40341402',
      '32004310',
      '21134130',
      NULL,
      '10102033',
      '23102422',
      '14411301',
      '30423103',
      '31234010',
      '23130030',
      NULL,
      '21021001',
      '30220112',
      '11123340',
      '42312032',
      '13042314',
      '31113143',
      '01214024',
      '23204400',
      '14103300',
      '13400033',
      '43312234',
      '23133312',
      '14242413',
      NULL,
      '24323133',
      '21241232',
      '10042411',
      '24314120',
      '34201222',
      '33030043',
      '14022240',
      '10313434',
      NULL,
      '20201112',
      '44102222',
      NULL,
      '33234330',
      '13131204',
      '12420124',
      '23400200',
      '304',
      '21',
      NULL,
      NULL,
      '0203402',
      NULL,
      1.619419,
      NULL,
      NULL,
      NULL,
      5,
      ' 6-27-1984',
      ' 2-24-1991',
      6,
      NULL,
      18,
      11,
      6,
      11,
      33.630777,
      11.780101,
      24,
      9.908542,
      16,
      6.372124,
      17.400414,
      14.198187,
      30.169957,
      17,
      0.710261,
      0.935560,
      7.055925,
      15,
      NULL,
      19,
      55.139417,
      12.150874,
      0.508583,
      49,
      NULL,
      NULL,
      NULL,
      119,
      81,
      '10-21-1995',
      14.528058,
      44.888793,
      29.157234,
      NULL,
      137,
      111,
      ' 2-29-1988',
      NULL,
      NULL,
      0.396472,
      5.286225,
      1,
      0.376000,
      9.581805,
      0,
      0.492353,
      NULL,
      2.653066,
      1,
      1,
      4.056323,
      0,
      1.050779,
      0.214923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1991',
      22.643149,
      8,
      16.747170,
      0.603211,
      21.747911,
      7,
      ' 9- 0-1975',
      0,
      0,
      120.969387,
      1,
      1,
      NULL,
      0.095093,
      3.929496,
      NULL,
      NULL,
      1,
      116,
      ' 3- 5-1981',
      42.656257,
      NULL,
      NULL,
      NULL,
      72.486622,
      88,
      9.296095,
      34.246709,
      54,
      74.630377,
      86.140993,
      NULL,
      '11-25-1975',
      0,
      18,
      1,
      1.513191,
      14.474896,
      80,
      NULL,
      ' 1-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1998',
      NULL,
      17.454146,
      ' 0- 9-1982',
      17,
      7,
      NULL,
      31.106361,
      ' 1-11-1987',
      NULL,
      ' 5- 4-1995',
      3.580514,
      11.688571,
      '11-18-1995',
      106,
      NULL,
      ' 7-19-1997',
      2,
      5,
      ' 7- 1-1977',
      3.055907,
      11,
      '11-21-1998',
      1,
      NULL,
      22.473246,
      ' 1- 6-1998',
      1.833718,
      5,
      20.894822,
      ' 9- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


