set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0302',
      '42442030',
      '30423240',
      '41201134',
      '03223123',
      '40401111',
      NULL,
      '40333300',
      '12333120',
      '43013420',
      '40344142',
      '30000102',
      '21103222',
      NULL,
      '24324133',
      '32233041',
      '12023402',
      NULL,
      '21011131',
      '30004134',
      '34042131',
      '41021002',
      '31412032',
      '33434440',
      NULL,
      '21041411',
      '24443043',
      '02100411',
      '23411433',
      '23442144',
      '11200021',
      '41020030',
      NULL,
      '21102041',
      '32444230',
      '32332024',
      '43344103',
      '00234434',
      '40401033',
      '10443012',
      '32421314',
      '21114420',
      '43111023',
      '33133104',
      '42222334',
      '140',
      '21',
      NULL,
      NULL,
      NULL,
      1.799649,
      NULL,
      0,
      NULL,
      '034424',
      5.391023,
      NULL,
      NULL,
      89.693577,
      NULL,
      NULL,
      24,
      NULL,
      17.533216,
      45,
      20,
      13,
      NULL,
      NULL,
      16.738633,
      8.754197,
      13.574717,
      NULL,
      1,
      33.522534,
      20,
      33.563195,
      NULL,
      47.590316,
      NULL,
      NULL,
      10,
      0.473926,
      49.774080,
      125.892346,
      6.216771,
      122.992909,
      11.817060,
      204.178654,
      ' 1-22-1986',
      11,
      35,
      NULL,
      13,
      106.538262,
      144,
      NULL,
      1,
      0,
      4,
      1.096733,
      3.887344,
      NULL,
      3.013926,
      0.014047,
      0.024364,
      0,
      0.941956,
      0.008568,
      1,
      2,
      0.179686,
      NULL,
      2.471243,
      1,
      1.168630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      14,
      10.452817,
      12,
      1.092041,
      NULL,
      ' 3-22-1982',
      0.437940,
      NULL,
      133,
      0,
      3.931093,
      97.244533,
      1,
      1.186750,
      NULL,
      0,
      0.721454,
      7.270365,
      NULL,
      51,
      NULL,
      50.371670,
      16.116898,
      NULL,
      17,
      57,
      56,
      NULL,
      NULL,
      0.467489,
      11.396286,
      ' 0- 0-1976',
      11.054887,
      18.861507,
      16.454865,
      14,
      NULL,
      51.422798,
      8,
      ' 9-21-1975',
      9,
      4.565653,
      NULL,
      0,
      5.493066,
      10.768874,
      9,
      6,
      NULL,
      0.983486,
      8,
      1,
      13,
      1.184081,
      0.417899,
      3,
      NULL,
      4,
      0,
      0.061279,
      0.748510,
      ' 5- 2-1986',
      1,
      6,
      NULL,
      ' 8-26-1986',
      162,
      14.898582,
      ' 8- 7-1989',
      NULL,
      NULL,
      NULL,
      15.321392,
      ' 2-10-1979',
      0.275369,
      '11- 5-1974',
      2,
      5,
      ' 3-25-1990',
      71,
      98,
      ' 2-22-1988',
      NULL,
      0,
      NULL,
      3.335842,
      2.551267,
      ' 4- 2-1984',
      1,
      3,
      NULL,
      NULL,
      6.497968,
      37.743808,
      NULL,
      ' 4-29-2002',
      1.282212,
      22,
      ' 7-10-1999',
      7,
      NULL,
      18.858376,
      6,
      '10- 5-1979',
      40.949819,
      0.469500,
      97.328817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


