set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20142313',
      '42100223',
      '10223000',
      '32313413',
      '22111123',
      '03430443',
      '11213022',
      '12103132',
      '24202333',
      '42430412',
      '22110013',
      '04120230',
      '23042001',
      NULL,
      '11124110',
      '31120340',
      '33242012',
      NULL,
      '33110342',
      '01443344',
      '13240232',
      '23043314',
      '03222140',
      '21233134',
      '21444010',
      '40040124',
      '42121211',
      '03402300',
      '43323340',
      '02231024',
      NULL,
      '34020310',
      '13330014',
      NULL,
      '21400243',
      '14000004',
      NULL,
      '33104423',
      NULL,
      '43314023',
      '31423402',
      '20113024',
      '01414244',
      NULL,
      NULL,
      '04',
      NULL,
      NULL,
      '1214204',
      3.711820,
      NULL,
      2,
      NULL,
      '334202',
      4,
      ' 3-17-1982',
      ' 6-28-1999',
      4.043178,
      NULL,
      22,
      13,
      12,
      NULL,
      1,
      7,
      12.508694,
      0,
      15,
      NULL,
      NULL,
      NULL,
      2.722584,
      3.534746,
      29,
      1.512692,
      57.482420,
      10.542778,
      49.526059,
      19.608187,
      12.397983,
      10,
      1,
      7.445053,
      191,
      5.982051,
      164.163554,
      39.844233,
      NULL,
      ' 3-17-1987',
      5,
      27.359105,
      15.780520,
      8.169015,
      39.818755,
      32,
      ' 6-27-1985',
      0,
      1.965148,
      1.044255,
      3.740235,
      0.054945,
      1.861249,
      1,
      0.913954,
      0.382308,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0.856975,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-13-1980',
      95.149323,
      NULL,
      1.140066,
      5,
      2.008909,
      2,
      ' 7- 3-1994',
      1,
      0,
      108,
      NULL,
      1.364852,
      23.236758,
      0,
      1,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.398480,
      13.667384,
      34,
      85,
      54.827824,
      63,
      NULL,
      83.868203,
      NULL,
      29.037115,
      46,
      NULL,
      0.306920,
      24,
      11,
      12,
      62.849657,
      NULL,
      9.598772,
      ' 5- 3-1995',
      8.050484,
      16,
      ' 2-21-1978',
      5.828778,
      4.482565,
      NULL,
      8,
      11,
      11,
      0.308446,
      2.219031,
      3.824581,
      31.441287,
      NULL,
      1,
      7,
      NULL,
      9,
      NULL,
      NULL,
      0.001882,
      '11- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3-24-1999',
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      8,
      ' 9- 7-1983',
      12.271664,
      7.136930,
      ' 6-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      0.262718,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      NULL,
      52,
      6,
      NULL,
      0,
      114.550180,
      ' 2-17-1988',
      10.467437,
      NULL,
      NULL,
      8.412080,
      '10- 2-2003',
      NULL,
      1,
      137.219851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


