set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4133',
      '12010244',
      NULL,
      '14130211',
      '41030411',
      NULL,
      '33413343',
      '34022421',
      '13201041',
      '01304444',
      '33033420',
      '12033324',
      NULL,
      '30022113',
      NULL,
      '20434110',
      '12203011',
      NULL,
      '21000222',
      '30344110',
      '11110203',
      '01331200',
      '21414342',
      '10314104',
      '24011212',
      '21042400',
      NULL,
      '20012444',
      '01110443',
      NULL,
      '21133423',
      '12310102',
      '24100044',
      '34440124',
      '04140132',
      '23010242',
      '00402144',
      '32241042',
      NULL,
      '14012012',
      '10344314',
      '31200440',
      NULL,
      '00043401',
      '31424022',
      '031',
      '30',
      1.297413,
      NULL,
      '3031030',
      0,
      107,
      NULL,
      NULL,
      '102034',
      5,
      NULL,
      ' 1- 1-1987',
      88.342659,
      57,
      24.393449,
      25,
      8,
      6,
      NULL,
      NULL,
      4,
      2.076270,
      17.225048,
      3.844839,
      NULL,
      15.527998,
      28,
      20,
      16,
      14.136399,
      82.807409,
      NULL,
      39,
      10,
      30,
      NULL,
      0.066988,
      28.413709,
      NULL,
      NULL,
      29.433095,
      40.790407,
      80,
      ' 8-10-2002',
      50,
      27,
      32.132931,
      16,
      132,
      67,
      ' 4-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      12.466881,
      4.695928,
      NULL,
      7.595767,
      5,
      ' 1- 1-1995',
      1,
      0.130974,
      215,
      0,
      1,
      75.425842,
      0.239931,
      1,
      54,
      NULL,
      NULL,
      NULL,
      '10-18-1979',
      NULL,
      NULL,
      12.162101,
      101.706147,
      76.672223,
      50.944589,
      53.643407,
      51.978973,
      28.273694,
      56.363349,
      21.409433,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      23.800892,
      17,
      NULL,
      NULL,
      ' 9-14-1984',
      5,
      2,
      ' 3-18-1993',
      5.943652,
      NULL,
      11,
      1,
      2.623957,
      0.078549,
      0.341837,
      5,
      1.145808,
      63.528213,
      3,
      1,
      1.626954,
      NULL,
      11,
      NULL,
      4,
      3,
      ' 4-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      ' 3- 1-1981',
      40,
      '11-25-1986',
      4,
      14,
      ' 0-19-1978',
      83.899753,
      NULL,
      ' 3-19-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.676000,
      NULL,
      42.015143,
      50.082295,
      49.181355,
      ' 6-24-2001',
      0,
      120.838457,
      ' 3- 6-1990',
      3.633501,
      9,
      2.195342,
      24,
      ' 0- 3-1974',
      50.221505,
      NULL,
      NULL,
      ' 4-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


