set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '1',
      '4',
      '2',
      '4',
      NULL,
      '3',
      '0',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '1',
      '2',
      '1',
      '1',
      '0',
      '2',
      '1',
      NULL,
      '3',
      '4',
      '',
      '1',
      NULL,
      '0',
      '1',
      '1',
      '3',
      '4',
      NULL,
      '',
      '0',
      '2',
      '2',
      NULL,
      '3',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '2',
      '100',
      '43304102',
      14,
      NULL,
      '3302021',
      3.545793,
      173,
      0,
      0,
      NULL,
      4.370838,
      ' 1- 8-1975',
      ' 1- 3-1991',
      60,
      57.326026,
      0,
      6.991754,
      14.166777,
      5.152354,
      73.780107,
      5.325817,
      7.884850,
      NULL,
      15,
      14.543180,
      8,
      2,
      15,
      14,
      16.566530,
      15.490247,
      0.319316,
      2.524952,
      40,
      7.976701,
      NULL,
      11.219313,
      0,
      NULL,
      102.192625,
      63.198349,
      84.537035,
      56,
      149.463317,
      ' 8-10-1977',
      34.275577,
      NULL,
      21,
      NULL,
      117,
      43.201817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      4.846620,
      2.274872,
      5,
      NULL,
      NULL,
      NULL,
      1.808628,
      1.688116,
      NULL,
      1.976151,
      1,
      NULL,
      1.719562,
      4.671007,
      36,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1999',
      NULL,
      NULL,
      16.395826,
      0.628298,
      29.567943,
      0,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      5.838706,
      ' 8-15-1987',
      NULL,
      5.870808,
      3,
      15.369147,
      NULL,
      NULL,
      2,
      ' 3- 9-1998',
      6,
      NULL,
      ' 9- 4-1974',
      NULL,
      7,
      12,
      NULL,
      6,
      5.502533,
      1,
      NULL,
      0,
      39,
      6.692511,
      1.619033,
      1,
      18,
      5.605568,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72.350230,
      11,
      ' 2-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1998',
      3.335254,
      4,
      NULL,
      NULL,
      NULL,
      ' 1-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.616784,
      ' 9- 2-1987',
      20.638379,
      21,
      13.620629,
      NULL,
      NULL,
      211,
      '11- 0-1986',
      2.036433,
      105.187481,
      NULL,
      28.654286,
      ' 3- 8-1988',
      44.007848,
      0.042105,
      47,
      ' 9-15-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


