set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '1',
      '2',
      NULL,
      '4',
      '4',
      '1',
      '0',
      '2',
      NULL,
      '0',
      '4',
      '4',
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3',
      '0',
      '0',
      NULL,
      '1',
      '',
      '4',
      '',
      '4',
      NULL,
      NULL,
      NULL,
      '2',
      '',
      '',
      '3',
      '2',
      '2',
      '1',
      '2',
      '3',
      '3',
      NULL,
      '0',
      '3',
      '0',
      '213',
      NULL,
      33,
      20.975766,
      '4242333',
      3.569896,
      NULL,
      3,
      0,
      '433233',
      2,
      '11- 9-1999',
      ' 8-15-1977',
      46,
      36,
      23,
      NULL,
      21.587141,
      15.891485,
      NULL,
      NULL,
      0,
      1,
      12.311873,
      21,
      40,
      14.622945,
      28.456857,
      NULL,
      25.493946,
      6,
      NULL,
      21.689006,
      NULL,
      3.910265,
      60,
      10,
      0.422513,
      41.253498,
      120.721134,
      8,
      NULL,
      80,
      129,
      ' 5- 6-1998',
      NULL,
      NULL,
      24.207963,
      25,
      15.815406,
      154,
      '11-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.040166,
      6.138758,
      2,
      0.912222,
      2,
      8,
      ' 8- 3-2003',
      NULL,
      1.772149,
      123.283599,
      2.158410,
      0.678046,
      43,
      0.942268,
      1.359477,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      37.780558,
      64.389233,
      85.134344,
      39.637881,
      33,
      80.973163,
      NULL,
      19.535990,
      NULL,
      NULL,
      62.238308,
      36,
      '10-20-1975',
      16.799731,
      5,
      11.180147,
      18,
      21.260972,
      7,
      5,
      '11-26-1991',
      24,
      NULL,
      ' 0-23-1977',
      9.402057,
      1,
      7,
      11,
      8.334711,
      0,
      0.876304,
      8.617861,
      1.573535,
      46.438868,
      0,
      0,
      4,
      18,
      7,
      2.140902,
      0,
      NULL,
      ' 9-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      150.047385,
      42,
      ' 4- 3-1998',
      NULL,
      NULL,
      NULL,
      16,
      ' 0- 2-1992',
      24,
      '10-15-1995',
      4,
      2.542820,
      ' 1-14-1983',
      70,
      87,
      ' 8-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.179005,
      NULL,
      43,
      41,
      35,
      NULL,
      3,
      51.871114,
      NULL,
      16,
      NULL,
      2.628936,
      27,
      ' 6-27-1977',
      48.672842,
      NULL,
      33.532218,
      ' 7- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


