set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3323',
      '43310334',
      '30232424',
      '00301432',
      NULL,
      '32210301',
      '10400420',
      '23423203',
      '40420310',
      NULL,
      '11024341',
      '01301342',
      '00320013',
      '40304210',
      NULL,
      '01412211',
      '32344303',
      NULL,
      '44143002',
      '20141322',
      '01000044',
      '32322010',
      '43312030',
      '00204321',
      '02433044',
      NULL,
      '32110401',
      NULL,
      '20043022',
      NULL,
      '12022310',
      '12132101',
      '14221214',
      '44431041',
      '21240041',
      '02124144',
      NULL,
      '10343234',
      '41420422',
      '02333314',
      '40403102',
      '44231430',
      '01024011',
      '12432320',
      '11112302',
      NULL,
      '13',
      NULL,
      NULL,
      '0113400',
      1.021815,
      NULL,
      0,
      NULL,
      '113420',
      1,
      ' 6-29-1985',
      NULL,
      24,
      NULL,
      8,
      8,
      23,
      8.397789,
      30.338088,
      17.632057,
      10,
      3.218852,
      NULL,
      3,
      37,
      3.628619,
      27.878292,
      NULL,
      2.101585,
      11,
      62.634444,
      12.902436,
      0,
      18,
      41,
      NULL,
      1,
      49.168814,
      51,
      61.353529,
      136,
      NULL,
      39,
      ' 9- 9-1986',
      17.276933,
      48,
      19.732468,
      12.285483,
      46.889703,
      NULL,
      ' 7- 2-1982',
      NULL,
      3,
      6.552139,
      NULL,
      2.295287,
      NULL,
      6.571574,
      1,
      0,
      0,
      1,
      1,
      0.352002,
      5.458230,
      0.074138,
      1,
      0.511167,
      1,
      1,
      0.242457,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-16-1981',
      35,
      NULL,
      63,
      7,
      17,
      NULL,
      ' 2- 7-1978',
      NULL,
      0,
      NULL,
      0,
      4.791451,
      22.573251,
      0.884246,
      2.335419,
      2.491626,
      1,
      NULL,
      43.921312,
      ' 3-24-2000',
      79.597025,
      19.756581,
      42,
      11.977056,
      NULL,
      NULL,
      80,
      17.779820,
      NULL,
      15.624183,
      17.702072,
      12,
      NULL,
      13,
      3.875033,
      0.606995,
      NULL,
      1,
      7,
      7,
      '10- 7-1993',
      0.169318,
      6.036041,
      NULL,
      NULL,
      9,
      9.808009,
      10.789164,
      5.558290,
      8,
      NULL,
      8,
      1.088883,
      11,
      11.296185,
      0,
      3.718324,
      NULL,
      2.026945,
      1.864668,
      1,
      1,
      '10-27-1985',
      2.030832,
      NULL,
      4.415095,
      ' 6-25-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      9,
      NULL,
      62.004791,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.805362);
commit;
end;
/


