set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4210',
      '14111433',
      '30141403',
      '04101441',
      NULL,
      '11442211',
      '13303322',
      '04301144',
      '34043043',
      '23313202',
      '01313144',
      '30041133',
      NULL,
      '11400342',
      '43314004',
      '34401411',
      NULL,
      '24442010',
      '42201104',
      '24141322',
      '24030430',
      '41011231',
      '03140003',
      '20204444',
      '34124200',
      NULL,
      '14133241',
      '20121013',
      '21414210',
      '10010133',
      '00342101',
      '11322024',
      '41433230',
      '12400004',
      '12300401',
      '41233332',
      '02412002',
      '23002144',
      '30203241',
      '22043013',
      '00033114',
      '24123324',
      '31311330',
      '01423411',
      '43343132',
      '221',
      '20',
      12.820014,
      5.341056,
      '4031431',
      2,
      1.829255,
      0,
      NULL,
      NULL,
      NULL,
      ' 9-20-1987',
      ' 2-26-1999',
      43.705448,
      NULL,
      NULL,
      7.982813,
      14,
      7,
      NULL,
      9.142109,
      6,
      6.990056,
      7,
      13,
      12.234425,
      21,
      32,
      2.236432,
      NULL,
      3,
      20.238603,
      9,
      NULL,
      10.618226,
      53,
      6.749546,
      0.593896,
      15,
      109.504427,
      94,
      52,
      69.445020,
      115,
      '10-24-1994',
      33,
      55,
      22.736205,
      30.709668,
      74.317254,
      2,
      ' 2-20-1992',
      0.465770,
      NULL,
      1.157801,
      NULL,
      1,
      0.873056,
      5.393187,
      2,
      0,
      0.853592,
      5,
      NULL,
      1,
      2.845511,
      0.048524,
      0,
      0,
      1.195929,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 0-1980',
      73.946738,
      33,
      NULL,
      16.685229,
      20.540338,
      1.953312,
      ' 8- 7-1993',
      0.465816,
      2.819093,
      130.207351,
      0,
      1.943054,
      NULL,
      1,
      0.046883,
      39,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1984',
      63,
      46.676035,
      40,
      NULL,
      59,
      24.098408,
      NULL,
      56.703813,
      NULL,
      82.645540,
      NULL,
      NULL,
      ' 4- 2-1984',
      2,
      NULL,
      19.241914,
      10,
      30,
      4,
      9,
      ' 4- 4-1990',
      18.407155,
      NULL,
      '11-21-1981',
      6,
      9,
      2,
      0.755552,
      5,
      NULL,
      2.664858,
      8.926023,
      1,
      NULL,
      0,
      3,
      4.064486,
      12.700474,
      3.522723,
      10,
      NULL,
      3.204777,
      ' 0-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      162.347980,
      9.650274,
      NULL,
      NULL,
      NULL,
      NULL,
      37.993408,
      ' 0- 9-1990',
      NULL,
      ' 7-12-1991',
      1,
      7.006032,
      '10- 5-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      4.146416,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 6-21-1981',
      NULL,
      10.586596,
      27.344670,
      ' 6-25-1980',
      1,
      109.609798,
      NULL,
      NULL,
      59.598462,
      7.966296,
      29,
      ' 9-25-1998',
      50.557132,
      1.697667,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


