set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130040';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4142',
      '23433422',
      '44311112',
      '22434134',
      '10100142',
      '34001232',
      '44431321',
      '00000031',
      '40434244',
      '22411133',
      '11222014',
      '03132044',
      '11210102',
      '03113411',
      '12443200',
      NULL,
      '42300242',
      '41402313',
      '12022100',
      '42104013',
      '32002003',
      '14013202',
      NULL,
      '34012034',
      '43421001',
      NULL,
      '22213213',
      '01121432',
      '00341021',
      NULL,
      '20004404',
      '20432434',
      '20131000',
      '13313111',
      '43241044',
      NULL,
      '41302102',
      '12134134',
      NULL,
      '00423210',
      '14231144',
      '01143141',
      '31432012',
      '24043401',
      '22301031',
      '243',
      '24',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      ' 1-11-1989',
      ' 1-23-1997',
      NULL,
      NULL,
      NULL,
      3.553922,
      29,
      17,
      11.224095,
      NULL,
      NULL,
      6.246441,
      4.415284,
      NULL,
      8.007512,
      19.876337,
      27,
      16.906995,
      2.161814,
      15.359171,
      NULL,
      14,
      63.065172,
      27.626598,
      24,
      NULL,
      0.732246,
      99,
      140.558078,
      NULL,
      2.744129,
      114.269795,
      1,
      ' 2-12-1999',
      67.026233,
      NULL,
      28.780921,
      4,
      167,
      NULL,
      '10- 7-1990',
      0.126558,
      2,
      0.843903,
      1,
      0.915689,
      0,
      0.451074,
      3.159916,
      0.248324,
      1,
      3.691475,
      1.843467,
      1,
      NULL,
      0.743822,
      1,
      1.726829,
      1,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1999',
      67.754486,
      27.743117,
      35.124501,
      15,
      1,
      3.168004,
      ' 1- 8-1977',
      0,
      0.725996,
      221,
      0,
      3.995182,
      103.327519,
      NULL,
      NULL,
      NULL,
      0,
      0.410524,
      160,
      ' 9-16-1978',
      7,
      83,
      78.812893,
      37.169109,
      54.351373,
      NULL,
      NULL,
      46,
      NULL,
      NULL,
      7.721688,
      66,
      ' 9-22-1992',
      16.976587,
      NULL,
      NULL,
      23.734960,
      57.669381,
      NULL,
      NULL,
      ' 8-26-1984',
      5.973409,
      NULL,
      NULL,
      4,
      9.941513,
      17.337666,
      23,
      14,
      NULL,
      0,
      4,
      0,
      114.096701,
      1.494408,
      NULL,
      NULL,
      3.276929,
      4.371898,
      NULL,
      0.649777,
      2,
      ' 4-10-1978',
      6,
      0.309146,
      4,
      ' 9-16-1980',
      258,
      1.892112,
      NULL,
      NULL,
      17,
      ' 3- 8-1993',
      NULL,
      '10-29-1990',
      28,
      ' 1-12-1980',
      12.750116,
      1.116916,
      ' 5- 8-1977',
      NULL,
      97.923055,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      5.048621,
      ' 6-28-1982',
      3,
      3,
      8.444426,
      '11-17-1981',
      46,
      NULL,
      47.468068,
      '10-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


