set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6917568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0331',
      '13323040',
      '13422343',
      '30104412',
      NULL,
      '03042141',
      '03323220',
      NULL,
      NULL,
      '00434223',
      NULL,
      '33124214',
      '21432442',
      '10412440',
      NULL,
      '41423133',
      '01343033',
      NULL,
      '02032414',
      '21012333',
      '24124214',
      NULL,
      '32434244',
      '01121432',
      '23213410',
      '22230020',
      '13231200',
      '30304002',
      '32142241',
      '43211301',
      '43120322',
      NULL,
      '04312113',
      '24403341',
      '43224202',
      '21223001',
      '20004430',
      '21143020',
      '43440430',
      NULL,
      '01234413',
      NULL,
      '12100133',
      '31413040',
      '00022200',
      NULL,
      '22',
      NULL,
      NULL,
      '4410323',
      NULL,
      0.220936,
      2,
      NULL,
      '414102',
      NULL,
      NULL,
      ' 3-16-1987',
      23,
      NULL,
      24,
      4.575126,
      5,
      5,
      47.758707,
      16,
      2.029803,
      NULL,
      36,
      22,
      34.336533,
      10.042832,
      13,
      3.426397,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      17,
      17,
      1.541785,
      98.315747,
      94.934522,
      NULL,
      160,
      23,
      160,
      ' 3- 0-1975',
      37,
      13,
      32.002448,
      21,
      NULL,
      121,
      NULL,
      3.598889,
      NULL,
      1,
      0,
      0,
      1.164112,
      1.794833,
      11.893834,
      1,
      0,
      3,
      0.558001,
      1,
      4.811580,
      NULL,
      1.358857,
      NULL,
      0.893936,
      1.424733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-1997',
      NULL,
      31,
      20.762667,
      6.618842,
      NULL,
      2,
      NULL,
      NULL,
      1.004937,
      148,
      0.766823,
      1,
      48,
      0,
      NULL,
      48.230177,
      NULL,
      NULL,
      NULL,
      '11-11-2000',
      62,
      NULL,
      58,
      36,
      63.286641,
      NULL,
      NULL,
      44,
      20.551442,
      2,
      23.704816,
      33,
      ' 6-14-1998',
      32,
      9.791812,
      30.043217,
      NULL,
      45.949770,
      21,
      2,
      ' 3-15-1987',
      NULL,
      NULL,
      ' 2-29-1977',
      7.853515,
      15,
      6.684054,
      NULL,
      1,
      10,
      0.757535,
      9,
      NULL,
      111,
      0.005456,
      1,
      16.929601,
      20,
      7.358453,
      0,
      1.327972,
      1.117517,
      ' 5-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      0.128379,
      '10- 9-1987',
      NULL,
      NULL,
      NULL,
      8.714554,
      ' 9-23-1976',
      7,
      '10-22-1981',
      1.560566,
      7.758050,
      ' 8-11-2001',
      25,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 5-26-1996',
      4,
      NULL,
      19,
      ' 7- 7-1994',
      1.305865,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


