set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4201',
      NULL,
      '04440233',
      '24321423',
      '23234234',
      '30013410',
      '00032342',
      '21002233',
      NULL,
      '42320202',
      '11432144',
      '33123203',
      '30110140',
      '00212031',
      '04024330',
      '44223424',
      '21030023',
      NULL,
      '12030134',
      '22203224',
      '34342303',
      '33441112',
      '24202002',
      NULL,
      NULL,
      '43344313',
      '00231433',
      '44043132',
      '10333000',
      '42342442',
      '14441133',
      '14312333',
      NULL,
      '04100201',
      NULL,
      '10413104',
      '10433223',
      '03201341',
      '43333320',
      '03230040',
      NULL,
      '43102134',
      NULL,
      '30143014',
      NULL,
      '132',
      '00',
      NULL,
      NULL,
      NULL,
      1.532903,
      1,
      0,
      NULL,
      '402444',
      4,
      ' 1-15-1979',
      ' 6-14-1990',
      2.562631,
      NULL,
      26,
      23,
      18,
      NULL,
      106.933321,
      1,
      7,
      14,
      24,
      14.875872,
      41,
      NULL,
      2.669248,
      13.759938,
      17.554452,
      7.777132,
      NULL,
      21.089608,
      NULL,
      16.736031,
      86,
      3.469219,
      NULL,
      77,
      167,
      29.737024,
      174.354673,
      159.876601,
      98.674816,
      NULL,
      62.119501,
      43.909303,
      NULL,
      29,
      132,
      31,
      ' 5-24-1995',
      2.426234,
      1,
      0,
      0.522701,
      1,
      1.022251,
      0,
      0.619487,
      NULL,
      1,
      1,
      1.836492,
      1.687592,
      0,
      0.054640,
      1,
      0.787368,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-2003',
      73.871237,
      NULL,
      7.643477,
      5.046727,
      9.491328,
      9.713182,
      ' 0- 4-1980',
      0.995125,
      NULL,
      NULL,
      NULL,
      1,
      50,
      NULL,
      1.408379,
      NULL,
      NULL,
      0,
      74.102707,
      ' 6-20-1990',
      57,
      14.621352,
      83.473932,
      64.340599,
      24.815964,
      124.528004,
      NULL,
      38,
      13.090262,
      134,
      109.681690,
      1,
      ' 4- 7-1975',
      NULL,
      20,
      3,
      NULL,
      14.407367,
      25.292268,
      7,
      ' 5-28-2003',
      18.291939,
      6,
      ' 0-17-1981',
      4,
      10.685874,
      16,
      23.759921,
      NULL,
      NULL,
      1,
      11.388894,
      0.888757,
      NULL,
      1,
      15,
      18.582740,
      17.505572,
      0,
      NULL,
      1,
      0.098207,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1979',
      NULL,
      0,
      '10-12-1981',
      16.499978,
      3.862080,
      NULL,
      19.837931,
      ' 7-13-2001',
      14.351649,
      ' 1-18-1983',
      7,
      13,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1999',
      NULL,
      NULL,
      NULL,
      0.179331,
      2,
      '10-10-1992',
      2,
      1,
      1.130285,
      ' 1-18-1986',
      21,
      17,
      NULL,
      ' 0-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


