set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7826448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1422',
      '23032213',
      '03241113',
      '40442114',
      NULL,
      '20220301',
      '20314410',
      '41303132',
      '10413012',
      '44124002',
      '32311243',
      '40400320',
      NULL,
      '10014202',
      '23142234',
      '14214134',
      '22024424',
      '04232314',
      '23330341',
      '01003044',
      '00312003',
      NULL,
      '41404232',
      '10022214',
      NULL,
      '34431413',
      '21243044',
      '01244431',
      '00441310',
      NULL,
      NULL,
      '22402202',
      '01124210',
      NULL,
      '23310132',
      '11410410',
      '42232233',
      '43404021',
      '34012424',
      NULL,
      '34444322',
      NULL,
      '04333300',
      '41414042',
      '41104441',
      '031',
      '41',
      2.370053,
      NULL,
      NULL,
      0,
      0.574909,
      3,
      NULL,
      '334010',
      2,
      '10-23-1975',
      ' 9-18-1977',
      60,
      105.574505,
      7.665397,
      7.916930,
      16.694995,
      2.839319,
      NULL,
      10,
      5.550525,
      5,
      19,
      NULL,
      NULL,
      11,
      0,
      1.473224,
      4.308120,
      11,
      12,
      4,
      20,
      NULL,
      44,
      11,
      0.455384,
      27,
      45,
      35.576533,
      2.276224,
      19,
      37.137554,
      ' 4- 4-1983',
      34,
      32,
      1.493755,
      31,
      NULL,
      7,
      ' 9-28-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.227032,
      0,
      1,
      16,
      NULL,
      2.017329,
      ' 4-18-1995',
      1,
      4.237238,
      100.921598,
      1,
      0,
      67,
      NULL,
      7.274927,
      9,
      NULL,
      NULL,
      NULL,
      ' 9-21-1990',
      32,
      56,
      9,
      9.196933,
      97.957717,
      44.887467,
      84,
      44.834001,
      73.324462,
      40.500688,
      72.615373,
      80,
      ' 2-14-2000',
      NULL,
      9.420015,
      4.467143,
      5,
      8,
      26.931679,
      1,
      ' 3- 1-1978',
      12.862232,
      10.947087,
      NULL,
      NULL,
      8,
      15.669692,
      0.049565,
      25.121649,
      7,
      1,
      10,
      1.548466,
      8.444875,
      17,
      1.390419,
      5,
      NULL,
      3.558244,
      NULL,
      7,
      0.279353,
      ' 5- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      22.284401,
      1.425357,
      ' 5-20-2003',
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      42.766173,
      ' 7-13-1983',
      7.566737,
      7,
      NULL,
      59,
      85.567933,
      ' 5-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      16,
      ' 2- 9-1974',
      NULL,
      9.774941,
      1.812553,
      ' 8-28-2000',
      NULL,
      55,
      NULL,
      13.431379,
      2.359568,
      0.135214,
      8.719286,
      NULL,
      28.296542,
      NULL,
      96,
      ' 4- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


