set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9680781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43441001',
      '11002234',
      '41001214',
      '01044300',
      '20434440',
      '00342400',
      '41432214',
      '40241132',
      '00110203',
      '41302004',
      '32233031',
      NULL,
      '41421034',
      '22214344',
      '10413201',
      '42003441',
      '40004211',
      '24000301',
      NULL,
      NULL,
      '30031101',
      '22323121',
      '01024441',
      '13034344',
      '24421443',
      '40242004',
      '11413112',
      '44421420',
      '00244211',
      '22311122',
      '33230240',
      '13244241',
      NULL,
      NULL,
      '22221232',
      '31100103',
      '12040031',
      NULL,
      NULL,
      NULL,
      '02042223',
      '02132110',
      '00340234',
      '14413330',
      '021',
      '20',
      27.319932,
      14,
      '2110113',
      1.641994,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 9-27-1980',
      ' 8-20-2001',
      85.524664,
      15.089101,
      37.188752,
      20.774025,
      11,
      19,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      7,
      3.114856,
      5.279277,
      21,
      NULL,
      23.059613,
      13,
      35.068706,
      5.759396,
      22,
      3.180255,
      1,
      26,
      24.281477,
      50.251678,
      125.362866,
      164.725748,
      NULL,
      ' 5-12-1985',
      34,
      57.988323,
      16.574447,
      27.705619,
      161.475248,
      125,
      '11- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      5,
      21.729489,
      7,
      NULL,
      2.180602,
      NULL,
      3,
      1.695685,
      133,
      1.870675,
      1.923676,
      85.845434,
      0.824411,
      1.865811,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1991',
      62.708538,
      75.379424,
      36.796597,
      NULL,
      2,
      70,
      48,
      43.369793,
      67,
      79,
      NULL,
      66.579754,
      '10- 4-1987',
      NULL,
      6.669675,
      14,
      19,
      10,
      4.083429,
      3,
      ' 7- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      2,
      ' 3- 4-2002',
      NULL,
      NULL,
      NULL,
      24.093099,
      ' 1- 6-1988',
      33.347697,
      ' 6-25-1998',
      5,
      10,
      ' 9- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.685357,
      '10-26-1997',
      46.722559,
      32.622001,
      17.354998,
      ' 6-21-1984',
      1.105564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


