set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2112',
      '00023440',
      '01413200',
      '12040304',
      '30112011',
      '02101333',
      '20223244',
      '21423130',
      '01014134',
      '14331122',
      '40320030',
      '02301403',
      '02332244',
      '03302310',
      '41130412',
      '03423314',
      '13241241',
      '32422144',
      '10103424',
      '42004410',
      '41222443',
      NULL,
      NULL,
      '13434142',
      '20310010',
      '30410323',
      '01443331',
      NULL,
      '20322141',
      '04133003',
      NULL,
      '41214132',
      '30414014',
      '40002441',
      '34401321',
      '00012423',
      '11423334',
      '43013434',
      NULL,
      '02202212',
      '11131102',
      NULL,
      '21013200',
      NULL,
      '10114101',
      NULL,
      NULL,
      36,
      20,
      '2222101',
      0,
      1,
      NULL,
      NULL,
      '323212',
      1,
      '11-18-1975',
      ' 6-13-1987',
      65,
      32,
      20,
      1.345006,
      11,
      NULL,
      23,
      14,
      18,
      17.102821,
      23.049001,
      NULL,
      13,
      13.106864,
      NULL,
      20,
      9,
      NULL,
      NULL,
      NULL,
      31,
      12,
      59,
      6,
      1,
      74,
      28.404838,
      53,
      NULL,
      39,
      121.899181,
      ' 7- 9-1994',
      49.077415,
      4,
      22.985513,
      5,
      51.844245,
      200.940528,
      ' 0-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 2-25-2002',
      1,
      1,
      115,
      NULL,
      0.342108,
      144.584265,
      2.826523,
      1,
      7,
      NULL,
      NULL,
      NULL,
      '10-25-2000',
      NULL,
      77,
      80,
      89.404079,
      100.144549,
      69,
      84,
      74,
      26.172553,
      22.039596,
      NULL,
      67,
      ' 9-11-1975',
      22,
      NULL,
      20,
      15,
      19.116403,
      124.319618,
      8,
      ' 0-27-1992',
      7,
      7.482404,
      NULL,
      3.930754,
      NULL,
      11,
      16.262007,
      4,
      2.072471,
      0,
      2.347996,
      NULL,
      2,
      0.101542,
      2,
      4.377924,
      14,
      2.002267,
      0,
      0,
      0.420996,
      ' 9- 7-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      241.053844,
      1.110709,
      ' 3-13-1978',
      NULL,
      NULL,
      NULL,
      14.105835,
      ' 2-26-1979',
      15,
      '11-12-1976',
      2.209302,
      4.474089,
      '11-20-1984',
      16,
      14,
      ' 1-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      14,
      ' 2-26-1992',
      57,
      11,
      NULL,
      '11-29-1996',
      1,
      58,
      ' 8-17-1994',
      14,
      17,
      22.199162,
      10,
      ' 1-23-1978',
      56.120028,
      1.793579,
      83,
      ' 4-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


