set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      '0',
      '0',
      '4',
      '2',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      '0',
      NULL,
      NULL,
      '3',
      NULL,
      '4',
      '2',
      '1',
      '0',
      '0',
      '2',
      NULL,
      NULL,
      '2',
      '',
      NULL,
      '4',
      NULL,
      '2',
      '1',
      NULL,
      '',
      NULL,
      '1',
      '2',
      '2',
      '3',
      '2',
      '0',
      '4',
      '4',
      '1',
      '0',
      NULL,
      '44104423',
      32,
      NULL,
      '1441300',
      0.639505,
      NULL,
      3,
      NULL,
      '014412',
      NULL,
      ' 7-21-1996',
      ' 7-12-1993',
      NULL,
      NULL,
      18.113274,
      11.326883,
      NULL,
      NULL,
      36.721830,
      2,
      8,
      13.510755,
      20.565342,
      NULL,
      NULL,
      1.777077,
      17,
      NULL,
      4.554925,
      NULL,
      1,
      11.083641,
      33.953578,
      3.290900,
      66,
      12,
      0,
      58.837495,
      140,
      33,
      103,
      18,
      81,
      ' 6-15-1980',
      43,
      43.251953,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.198254,
      NULL,
      10.090465,
      16.073863,
      9,
      4.233728,
      ' 7-13-2001',
      0,
      1.710316,
      NULL,
      NULL,
      0,
      74,
      3.968627,
      1,
      9,
      NULL,
      NULL,
      NULL,
      ' 5-18-1981',
      8,
      105,
      NULL,
      96.194025,
      81.200547,
      96.386972,
      69,
      55,
      34,
      33.726900,
      92.858694,
      13.749113,
      '10-16-1990',
      15.449141,
      NULL,
      NULL,
      8,
      35.040348,
      NULL,
      NULL,
      ' 5-28-1975',
      10.657769,
      2.177944,
      NULL,
      3.060750,
      5,
      8,
      11.097817,
      NULL,
      NULL,
      1.449332,
      11,
      1,
      52,
      0,
      0.346998,
      2,
      14,
      7,
      0.257410,
      1,
      0,
      ' 5-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 6-22-1994',
      NULL,
      NULL,
      NULL,
      35.767803,
      NULL,
      2.625645,
      NULL,
      11,
      3,
      ' 9- 5-1988',
      39.930637,
      79,
      ' 0- 8-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14.532070,
      '10- 6-1991',
      65.995334,
      NULL,
      0,
      ' 3-24-1993',
      1,
      43,
      NULL,
      16.536977,
      6,
      23.997060,
      NULL,
      ' 4-18-1980',
      7,
      1,
      101.814415,
      ' 0-22-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


