set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '1',
      '4',
      '0',
      '3',
      '0',
      NULL,
      '3',
      '2',
      '0',
      '1',
      NULL,
      '2',
      '1',
      '1',
      '1',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '2',
      NULL,
      '',
      '3',
      '',
      '3',
      '4',
      '2',
      '0',
      '2',
      '',
      '',
      '0',
      '2',
      '1',
      '4',
      '0',
      '4',
      '2',
      '0',
      '4',
      '4',
      '3',
      '131',
      NULL,
      25.831004,
      81.382285,
      '0300412',
      1.523146,
      27,
      0,
      1,
      '401402',
      6,
      NULL,
      ' 6- 7-1991',
      73.009068,
      178.027638,
      NULL,
      14,
      NULL,
      6.531196,
      55.571412,
      16.686093,
      NULL,
      8.089939,
      4.411834,
      NULL,
      16.175836,
      1,
      7.914498,
      5,
      11.593283,
      13,
      26.407880,
      NULL,
      24,
      NULL,
      49.697907,
      4.115105,
      1,
      14.605229,
      93.443871,
      27.051172,
      60.649210,
      17,
      120.230716,
      '11- 6-1989',
      53.720578,
      NULL,
      24,
      5,
      97.129870,
      4.655451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      9,
      11,
      8.082332,
      NULL,
      5,
      ' 0-18-1974',
      1.393636,
      NULL,
      76,
      0.081448,
      0,
      92.865965,
      1,
      0.360285,
      9.419067,
      NULL,
      NULL,
      NULL,
      '10-28-1975',
      38.469112,
      49.753925,
      59.570317,
      94.063816,
      93.043544,
      11,
      109.689350,
      3.989460,
      84.356643,
      61.568245,
      44.888801,
      33,
      ' 4- 6-1978',
      5.901263,
      NULL,
      15.188787,
      NULL,
      45.580016,
      NULL,
      8,
      ' 8- 8-1992',
      2,
      0.879720,
      ' 3-29-1981',
      NULL,
      0.913204,
      3.785030,
      3,
      3.863987,
      NULL,
      NULL,
      2.173610,
      NULL,
      38,
      0.075534,
      1,
      11.854533,
      9,
      1,
      7,
      0,
      1,
      '11-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      221,
      4.185028,
      NULL,
      NULL,
      NULL,
      NULL,
      28.239894,
      NULL,
      40,
      ' 4- 7-2003',
      NULL,
      1.629500,
      NULL,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 2-11-1984',
      21,
      NULL,
      6,
      ' 7-27-1987',
      0,
      2.247919,
      ' 7-18-2000',
      5,
      NULL,
      17.583294,
      33,
      ' 7-12-1982',
      49,
      1,
      163,
      ' 1- 6-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


