set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12002323',
      '32300003',
      '22420101',
      '33142041',
      NULL,
      NULL,
      '40403321',
      '21222440',
      NULL,
      NULL,
      NULL,
      '31223201',
      '31041121',
      NULL,
      '23004213',
      '40442203',
      '33244314',
      '40413400',
      '34424223',
      '02413122',
      '11231433',
      '23122032',
      '40331422',
      NULL,
      NULL,
      '44412231',
      NULL,
      '20222242',
      '00301040',
      '30301434',
      '44021033',
      '21333014',
      '43230304',
      '31403424',
      '12143332',
      '31300430',
      NULL,
      '41010344',
      '03134310',
      NULL,
      '13244334',
      '11244230',
      '43104042',
      NULL,
      '111',
      '21',
      NULL,
      NULL,
      '1430314',
      4,
      1,
      1,
      NULL,
      '033231',
      NULL,
      ' 2-22-1993',
      ' 4-25-1977',
      98.645912,
      NULL,
      NULL,
      NULL,
      4,
      11.788074,
      29,
      NULL,
      1,
      9,
      4,
      12.325145,
      NULL,
      1.886504,
      17,
      NULL,
      1,
      0.513773,
      8.884659,
      3,
      12.772704,
      4,
      NULL,
      9,
      NULL,
      NULL,
      108,
      40,
      33,
      NULL,
      4.141727,
      ' 9- 7-1996',
      0.796208,
      7.197713,
      23,
      5.224855,
      5.220832,
      21,
      ' 4- 8-1985',
      NULL,
      5.149227,
      11,
      19.257051,
      8,
      16.439637,
      10,
      7,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      1.520984,
      1,
      6.318803,
      NULL,
      0,
      11.886951,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1974',
      NULL,
      NULL,
      NULL,
      13.626579,
      12.977990,
      2,
      ' 8-27-1996',
      0.067030,
      0.923218,
      53.346091,
      NULL,
      0,
      51.995238,
      0,
      6,
      21,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1992',
      NULL,
      16.282263,
      5.272967,
      NULL,
      4,
      72,
      NULL,
      56,
      41.605308,
      33.981565,
      NULL,
      NULL,
      ' 3- 9-1977',
      4,
      NULL,
      0.185580,
      19,
      6.636431,
      NULL,
      3,
      ' 4- 6-1975',
      16,
      NULL,
      ' 7-12-1988',
      1.392846,
      7.387295,
      1.604874,
      4.305205,
      0.545340,
      4,
      1.775751,
      1.942750,
      1.083122,
      19.874843,
      NULL,
      1.662210,
      1,
      25.876574,
      6,
      8,
      7,
      NULL,
      ' 6- 1-1996',
      0.885809,
      0.913239,
      1,
      ' 8-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.930944,
      NULL,
      NULL,
      NULL,
      6,
      6,
      ' 1-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.432498,
      2,
      ' 5-26-1994',
      0,
      2,
      1,
      ' 2-15-1990',
      14,
      1.249858,
      6.404550,
      '11- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


