set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3243',
      '43310004',
      '04204034',
      NULL,
      '12342434',
      '01420402',
      '34410031',
      '41123313',
      '44314243',
      '33402011',
      '42202420',
      '43430413',
      NULL,
      '30330102',
      '32240042',
      '04441212',
      NULL,
      '01320010',
      NULL,
      '23020033',
      '43411041',
      NULL,
      '40002441',
      '10200204',
      '20442302',
      '34041424',
      '12213204',
      '10024310',
      NULL,
      '23223443',
      NULL,
      '31321021',
      '10212420',
      '30402440',
      '43130141',
      '02441104',
      '14041404',
      NULL,
      '20020120',
      '02221114',
      '31213101',
      '32444340',
      '42142423',
      '14221130',
      '41213130',
      '001',
      '22',
      NULL,
      17,
      '2403230',
      7.883096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-14-1980',
      NULL,
      122,
      NULL,
      2.774487,
      NULL,
      1,
      26,
      15.820873,
      15.860013,
      9,
      5.058605,
      13.821986,
      15,
      NULL,
      13.004370,
      7.302438,
      15,
      NULL,
      16.081471,
      7.833931,
      3,
      5.948312,
      40.241441,
      3.361381,
      0,
      106,
      NULL,
      33.039541,
      87.553792,
      24,
      84,
      ' 0- 0-1987',
      7,
      4.644882,
      NULL,
      NULL,
      49.783182,
      69.802401,
      ' 8- 0-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      40.093102,
      97,
      4.963222,
      36,
      0.201246,
      ' 7-28-1984',
      0,
      0.828524,
      38,
      3.957158,
      1,
      42,
      0.610921,
      2.104570,
      6.821442,
      NULL,
      NULL,
      NULL,
      ' 7-12-1976',
      NULL,
      23.896612,
      45,
      45,
      38.825487,
      49,
      23,
      0,
      37.218799,
      33,
      41,
      51,
      ' 7- 5-1994',
      3,
      2.692967,
      2.539583,
      4.618808,
      16.188318,
      2.462611,
      NULL,
      ' 0-14-1975',
      5,
      1.616695,
      ' 9- 5-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      '11- 4-1987',
      31.923088,
      '10-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      9.742811,
      '10-26-1984',
      27,
      9.279963,
      1.604057,
      '11-18-1984',
      NULL,
      224,
      ' 8- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.662517,
      0,
      214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


