set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34324100',
      '33300404',
      '00413113',
      '40242213',
      '23131002',
      '32321012',
      '34023240',
      '01011303',
      '31003003',
      '40033444',
      '12144201',
      '33221404',
      '13404122',
      '30133310',
      '01001321',
      '33244210',
      '02110312',
      '03300110',
      '42042104',
      '21400201',
      '02111341',
      '24344020',
      '24432334',
      '31433414',
      '14040132',
      '21401421',
      '14142404',
      '11203021',
      '02133233',
      '41210141',
      '11400303',
      NULL,
      NULL,
      '02441432',
      '30230324',
      '21122344',
      '20221003',
      '20003020',
      '01132400',
      '23114040',
      '13302043',
      '04004211',
      '22402413',
      '02423422',
      NULL,
      '34',
      NULL,
      NULL,
      '1412340',
      NULL,
      0.181061,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 0-10-1979',
      15,
      NULL,
      3.351634,
      6,
      7.867003,
      NULL,
      26.905230,
      6.130672,
      NULL,
      5,
      23,
      NULL,
      14,
      10.187822,
      17.982267,
      8,
      7,
      0,
      4,
      6.812203,
      20,
      2,
      20,
      1,
      NULL,
      30,
      84,
      31.592348,
      NULL,
      NULL,
      NULL,
      NULL,
      4.867936,
      4.202296,
      17,
      11.188323,
      NULL,
      149.582113,
      ' 0- 9-1987',
      NULL,
      1.024721,
      0.767945,
      3.003511,
      1.175910,
      1.761462,
      3.564697,
      0.448967,
      0.992502,
      0.976832,
      NULL,
      NULL,
      NULL,
      2.974242,
      NULL,
      NULL,
      1.601371,
      0,
      0,
      2.537209,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1989',
      57,
      14,
      28,
      33,
      17.910202,
      3.464910,
      ' 3-19-1991',
      0.851977,
      1.561887,
      13.761234,
      1,
      1,
      43,
      6.865333,
      1,
      27,
      1,
      0.940133,
      106.637936,
      ' 9-25-2001',
      0.731075,
      10.052391,
      58.595636,
      NULL,
      60,
      23.769871,
      28.610646,
      57,
      14,
      70,
      24,
      10.903178,
      NULL,
      0.232154,
      1.220671,
      1,
      15,
      26.100550,
      0.011784,
      3,
      NULL,
      6.412056,
      0,
      ' 9-28-1992',
      NULL,
      6.186886,
      16,
      9.309597,
      1,
      8.461199,
      1,
      NULL,
      0.571867,
      49.366562,
      1.353826,
      NULL,
      1,
      NULL,
      3,
      NULL,
      5,
      1,
      '11-22-1987',
      3,
      1.077012,
      2,
      ' 9- 0-2001',
      114.938584,
      69.254545,
      ' 6-11-1984',
      13.970455,
      31,
      ' 4- 7-1977',
      NULL,
      ' 6-26-1986',
      2,
      ' 5-14-2001',
      2,
      3,
      ' 1-21-1983',
      80,
      72,
      ' 1-22-1976',
      NULL,
      16.258412,
      NULL,
      0,
      0.486898,
      ' 0-28-1983',
      NULL,
      1,
      5,
      ' 0- 7-1994',
      NULL,
      4,
      17,
      ' 9-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


