set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4014',
      NULL,
      '33114013',
      '42021404',
      '40003320',
      NULL,
      '32002024',
      NULL,
      NULL,
      '40132242',
      '40441214',
      NULL,
      '24413124',
      '40021213',
      '00434100',
      NULL,
      '40122222',
      NULL,
      '30003432',
      '13031312',
      '33410123',
      '33223202',
      '41114333',
      '23010121',
      '42001130',
      '11110211',
      '01101330',
      '44204443',
      NULL,
      '12210422',
      '23031301',
      '33332030',
      NULL,
      '32221021',
      '32312114',
      NULL,
      '42211234',
      '42231230',
      '03002132',
      '10400402',
      '01244421',
      NULL,
      '00031121',
      NULL,
      NULL,
      '441',
      NULL,
      10,
      NULL,
      NULL,
      3,
      56,
      1,
      NULL,
      '214002',
      4,
      ' 7-23-2002',
      ' 1-16-1982',
      58,
      54,
      20,
      NULL,
      14,
      2.445840,
      32,
      NULL,
      1.855713,
      4,
      24,
      7,
      NULL,
      13.166283,
      0.215241,
      NULL,
      8,
      1,
      20.979965,
      3.060522,
      25.542021,
      20,
      34,
      8,
      0.388008,
      NULL,
      132,
      8.608599,
      NULL,
      21.072382,
      113,
      ' 5-19-2003',
      NULL,
      4.483174,
      NULL,
      NULL,
      132.852513,
      163.959026,
      ' 9- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.990738,
      NULL,
      4.612725,
      NULL,
      NULL,
      2.136249,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.778679,
      57.946077,
      3,
      0.126002,
      34,
      NULL,
      NULL,
      NULL,
      ' 6- 2-2003',
      95,
      88,
      27,
      83.842656,
      52,
      89,
      60,
      8.189012,
      NULL,
      NULL,
      94,
      41,
      ' 8-28-2000',
      NULL,
      4,
      NULL,
      15.873656,
      11,
      2.890816,
      NULL,
      ' 8-18-1986',
      NULL,
      NULL,
      ' 6- 5-1988',
      13,
      11.764914,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      53,
      NULL,
      0.606820,
      8.190691,
      18.133065,
      3,
      2,
      NULL,
      2.963101,
      '10- 0-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      115.795555,
      22,
      ' 7- 3-1977',
      NULL,
      NULL,
      NULL,
      40.027075,
      ' 5- 3-1994',
      25.439360,
      ' 9- 6-1986',
      6,
      12.927162,
      '11-15-1976',
      31.567601,
      NULL,
      ' 6-15-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      14,
      ' 1- 6-2000',
      20.611879,
      15,
      10,
      ' 1-25-1996',
      2,
      162,
      NULL,
      4.877214,
      NULL,
      14,
      NULL,
      ' 6- 7-1980',
      36.123330,
      0.010193,
      96,
      ' 3-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


