set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '0',
      '2',
      '3',
      '4',
      '3',
      '2',
      '4',
      '3',
      '4',
      '3',
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '0',
      '3',
      '3',
      '0',
      '2',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '4',
      '1',
      '1',
      '1',
      '',
      '',
      '3',
      '1',
      '4',
      '0',
      NULL,
      '4',
      '3',
      '3',
      '2',
      '3',
      '2',
      '114',
      '00423121',
      35,
      37,
      NULL,
      3,
      NULL,
      1,
      NULL,
      '104230',
      6.090251,
      ' 8-26-1999',
      ' 0-12-1975',
      80.759983,
      209,
      20,
      4.640318,
      4.253816,
      0,
      43.565128,
      17,
      2.980381,
      NULL,
      23,
      5,
      15.867844,
      1.217177,
      15,
      6.207799,
      NULL,
      4,
      NULL,
      NULL,
      47,
      0.805806,
      NULL,
      2,
      1.027445,
      24.239834,
      121.751757,
      NULL,
      72,
      56.520298,
      NULL,
      ' 4- 6-1978',
      20,
      NULL,
      17,
      5.269375,
      NULL,
      132,
      '11- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      6.355103,
      10.361053,
      5.648457,
      NULL,
      NULL,
      ' 2- 0-2002',
      0,
      1.129699,
      18.154685,
      NULL,
      0,
      54,
      3.383616,
      1.991414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      59.528234,
      56.468859,
      10,
      47.368944,
      11.553198,
      12.650857,
      64,
      111,
      NULL,
      82.151660,
      '11- 1-1976',
      3,
      NULL,
      8,
      1,
      37.989787,
      11.034300,
      NULL,
      ' 1- 0-1975',
      3,
      1,
      '11-18-1982',
      2,
      1.509068,
      5.617453,
      8,
      6,
      2,
      1.300025,
      NULL,
      1,
      24.863506,
      NULL,
      NULL,
      0.758741,
      13,
      13,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.704697,
      ' 6- 7-1985',
      19.092526,
      ' 9- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      ' 4- 2-1974',
      3,
      16.273826,
      5,
      ' 0-22-1997',
      2.064601,
      102.802134,
      ' 0-29-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-13-1985',
      22,
      0.961394,
      NULL,
      ' 7-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


