set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01441133',
      NULL,
      NULL,
      '42342112',
      '01123120',
      '10423142',
      NULL,
      '20013312',
      NULL,
      '43422222',
      '04044302',
      NULL,
      '24031410',
      NULL,
      NULL,
      '33444222',
      '11134022',
      '04022220',
      '34223024',
      '33411034',
      '12004341',
      '03112323',
      '32224242',
      '14013203',
      '14302043',
      '42420340',
      '42013312',
      '20320304',
      '40411024',
      '34201402',
      '01041140',
      '01414444',
      '11432301',
      '10303314',
      '40314012',
      '00030310',
      '42034034',
      '12103403',
      '21030213',
      '34430111',
      '00113304',
      '40422142',
      '32323143',
      '40102012',
      '',
      '',
      NULL,
      NULL,
      '4222204',
      2.517529,
      1,
      2,
      NULL,
      NULL,
      3,
      ' 6- 2-1986',
      ' 4-17-2002',
      0,
      NULL,
      NULL,
      16,
      21,
      NULL,
      13.067493,
      8,
      4,
      NULL,
      NULL,
      1.583258,
      6,
      12.770870,
      1.581926,
      11.416181,
      26.231007,
      12.302489,
      14,
      11,
      NULL,
      16,
      69.157852,
      7,
      NULL,
      16.835882,
      155.104587,
      0.896547,
      NULL,
      160.040180,
      137,
      ' 1- 2-1985',
      32,
      21,
      24.580485,
      4,
      NULL,
      NULL,
      ' 0-27-1984',
      1,
      NULL,
      1.254517,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      31.104143,
      NULL,
      90,
      108.826992,
      102.867722,
      40,
      NULL,
      NULL,
      75.813056,
      26,
      64,
      NULL,
      15.769382,
      NULL,
      15,
      19.226109,
      47.036542,
      2.424124,
      6,
      ' 4-28-1977',
      9.600630,
      1,
      ' 5- 2-1979',
      6,
      9,
      12,
      NULL,
      NULL,
      5.434729,
      NULL,
      14,
      NULL,
      40,
      NULL,
      21.237563,
      3.005171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      8,
      ' 4- 3-2003',
      2,
      NULL,
      ' 0-27-1992',
      10,
      18.636483,
      NULL,
      21.645969,
      ' 0-13-1989',
      12,
      0.092144,
      97,
      NULL,
      NULL,
      NULL,
      NULL,
      18.499127,
      44.326794,
      45.525876,
      NULL,
      9.526727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      0,
      7.089591,
      1.736316,
      0,
      0,
      2.420151,
      1,
      1.381451,
      1.719159,
      48,
      41,
      25,
      35.623780,
      21.055160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.781483,
      NULL,
      0,
      3.924316,
      10,
      NULL,
      NULL,
      61,
      80.669407,
      15.406779,
      53.021592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1983',
      ' 4- 9-2000',
      NULL,
      NULL,
      ' 3-27-1979',
      NULL,
      NULL);
commit;
end;
/


