set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2144',
      '12022330',
      '11002143',
      '11042411',
      NULL,
      '12021011',
      '44222021',
      '01424431',
      '24034401',
      '44340301',
      '24423243',
      '00311214',
      '24440333',
      '00444220',
      NULL,
      '30203310',
      '22100421',
      NULL,
      '41234101',
      '33343113',
      '00240332',
      NULL,
      '41124313',
      '13221314',
      NULL,
      '14221021',
      '04433333',
      '31033414',
      '31010043',
      NULL,
      NULL,
      NULL,
      '13223123',
      '13204134',
      '22011232',
      '33440232',
      '13032331',
      '42201144',
      '40234300',
      NULL,
      '01434244',
      NULL,
      '40340010',
      '43112300',
      '33114322',
      '033',
      '01',
      NULL,
      NULL,
      '1242224',
      NULL,
      NULL,
      1,
      NULL,
      '240321',
      2,
      ' 6- 2-2002',
      ' 0- 0-1995',
      30.038595,
      NULL,
      1,
      5,
      29.556730,
      15.220521,
      6,
      2.610431,
      9.965004,
      13,
      13,
      14.748164,
      15.233129,
      21,
      0,
      NULL,
      3,
      14.692720,
      11.861197,
      6.508806,
      NULL,
      5,
      NULL,
      12.171951,
      2,
      56.679803,
      NULL,
      59,
      59,
      161.127088,
      145.978553,
      ' 0-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.369130,
      4.549193,
      3,
      NULL,
      1,
      NULL,
      2,
      1.274458,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1.250580,
      2.832107,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1987',
      30,
      21,
      32.359718,
      15,
      21,
      1.064142,
      ' 0-26-1991',
      NULL,
      1.131531,
      139.303948,
      NULL,
      4,
      70,
      NULL,
      0,
      22.647772,
      1.976779,
      0,
      149.326903,
      ' 0- 2-2002',
      6,
      NULL,
      14.970277,
      NULL,
      NULL,
      5,
      8,
      94.241730,
      37.955850,
      49.508330,
      NULL,
      NULL,
      ' 9-20-1990',
      NULL,
      NULL,
      26,
      58,
      42,
      23.090915,
      11.273346,
      ' 7- 3-1977',
      6,
      8,
      '10-11-1988',
      1,
      1.823406,
      8.495769,
      NULL,
      11,
      4.664755,
      0.515118,
      11,
      0.468570,
      NULL,
      2.835094,
      NULL,
      3,
      25,
      1.140668,
      0,
      4.712349,
      0.652163,
      ' 9-14-1985',
      0,
      NULL,
      1,
      '11- 8-1986',
      33.901665,
      7,
      ' 4-23-1991',
      NULL,
      NULL,
      NULL,
      13,
      '10- 1-2000',
      15.437586,
      ' 3-17-1982',
      5.214479,
      NULL,
      ' 0-20-1976',
      NULL,
      76.564626,
      ' 6-14-1984',
      14.355707,
      2.366195,
      ' 9- 3-1982',
      1.939866,
      8.931765,
      NULL,
      NULL,
      0,
      16.457404,
      ' 1-26-1985',
      9.633065,
      8,
      NULL,
      ' 7-15-1976',
      5,
      83,
      '10-16-1997',
      1.966169,
      87,
      0.620495,
      85.943700,
      NULL,
      22,
      0.689707,
      124,
      ' 8-16-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


