set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100613';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0044',
      NULL,
      '13210432',
      '02342021',
      '11231122',
      '01041013',
      '01244140',
      '14124423',
      NULL,
      '32303330',
      NULL,
      '42312242',
      NULL,
      '24014030',
      '12100103',
      NULL,
      NULL,
      NULL,
      '44033042',
      NULL,
      '14031232',
      NULL,
      '31321440',
      '24014444',
      '13331411',
      '11442312',
      '12130140',
      '03434244',
      NULL,
      '41044300',
      '13111103',
      '22132313',
      NULL,
      NULL,
      '32343024',
      NULL,
      NULL,
      '24101211',
      '34124114',
      '12300311',
      '21344413',
      '44110014',
      '42324424',
      NULL,
      '42241020',
      '',
      '',
      NULL,
      NULL,
      '3440331',
      2,
      0,
      1,
      NULL,
      '414014',
      NULL,
      ' 5- 4-1998',
      ' 4- 2-1977',
      NULL,
      NULL,
      20.352487,
      NULL,
      NULL,
      14.759202,
      21.896903,
      NULL,
      NULL,
      3,
      24.684675,
      7,
      NULL,
      1,
      NULL,
      1.176616,
      0,
      10,
      35,
      5,
      NULL,
      8,
      4,
      6,
      NULL,
      52.736613,
      65.593638,
      8,
      112,
      122,
      NULL,
      ' 2-29-1992',
      0,
      15,
      NULL,
      12.077980,
      27.285333,
      186.212230,
      '11-16-1996',
      9.605529,
      5.891558,
      2.282660,
      4.880288,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.275864,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1987',
      38,
      31.543089,
      93.601337,
      0.993405,
      70.227833,
      39.955066,
      47,
      23.725799,
      43,
      52.973534,
      73.595504,
      56.291118,
      ' 7- 0-1980',
      NULL,
      3,
      7,
      44,
      58,
      22.474407,
      NULL,
      NULL,
      4.175024,
      NULL,
      ' 4- 9-1986',
      2.932152,
      12.868670,
      11,
      11.493603,
      0.620692,
      7,
      NULL,
      12,
      NULL,
      2,
      0.314952,
      34.458053,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      33,
      '11-14-1977',
      1.285526,
      103.837644,
      ' 6-15-1989',
      0,
      102,
      2.236473,
      50,
      ' 2-18-1978',
      NULL,
      1,
      NULL,
      ' 3-13-1992',
      NULL,
      NULL,
      NULL,
      1,
      7,
      40,
      59.135955,
      28,
      3.232015,
      38,
      19,
      0.626700,
      13.382769,
      NULL,
      77,
      0.448312,
      1,
      70.720577,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732104,
      39.367058,
      5.627240,
      NULL,
      56,
      NULL,
      20.265942,
      46,
      0.869642,
      3,
      0.869853,
      0.970649,
      0.681644,
      6.995735,
      0,
      1,
      10,
      36,
      57,
      NULL,
      51.094643,
      17.338395,
      1,
      1.663879,
      9.556095,
      NULL,
      1.604278,
      2,
      5,
      0.292026,
      64.324349,
      NULL,
      14.898469,
      NULL,
      1.174294,
      86,
      NULL,
      NULL,
      6,
      65,
      24,
      14,
      31,
      6,
      13.343608,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      77,
      NULL,
      NULL,
      '11-27-1987',
      '10-13-1996',
      NULL,
      ' 5-11-2001',
      ' 4-13-1977',
      NULL);
commit;
end;
/


