set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9020917';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2213',
      '11224034',
      '22111030',
      NULL,
      NULL,
      '22141320',
      '01210222',
      '22141301',
      '20210432',
      '23333341',
      '00003310',
      '13141230',
      '11130033',
      '00311000',
      '32021341',
      '44303230',
      '42302134',
      '01440121',
      '30013241',
      NULL,
      '21134340',
      '34102340',
      '24104443',
      NULL,
      NULL,
      NULL,
      '12034012',
      '43102111',
      '22234020',
      NULL,
      '00330244',
      '23312130',
      '04004341',
      '23023023',
      '22022001',
      '41023010',
      NULL,
      '43114111',
      '22133221',
      '32432011',
      '00434444',
      NULL,
      NULL,
      NULL,
      '11330104',
      '',
      NULL,
      NULL,
      NULL,
      '0414142',
      3.428546,
      0.663044,
      0,
      NULL,
      '222112',
      2,
      ' 8-25-1989',
      ' 8- 4-1998',
      77.040593,
      NULL,
      NULL,
      10.483905,
      NULL,
      NULL,
      NULL,
      3.236212,
      3.317574,
      1.024253,
      1.284300,
      1.160631,
      3,
      5.733188,
      19,
      NULL,
      13,
      4.075200,
      48,
      5,
      7,
      3.068624,
      14.045275,
      9,
      NULL,
      NULL,
      23,
      NULL,
      112,
      46.016088,
      47,
      '10- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      14,
      35,
      10.565015,
      11,
      13,
      ' 1- 0-1981',
      14.414787,
      7,
      ' 9- 0-1978',
      5.369452,
      NULL,
      5.271138,
      1,
      NULL,
      5,
      NULL,
      0.646495,
      NULL,
      31,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187453,
      130,
      ' 7-16-1994',
      5.698712,
      46,
      10.888174,
      47,
      ' 0-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6.993328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.287011,
      NULL,
      2.621222,
      57.236030,
      76,
      NULL,
      NULL,
      NULL,
      29,
      3,
      1,
      1,
      0,
      NULL,
      0,
      8.171129,
      NULL,
      NULL,
      NULL,
      NULL,
      77.250487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289941,
      0.264118,
      NULL,
      10,
      2.560043,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1.875051,
      1.182054,
      3.751385,
      3.052298,
      1,
      0,
      100.167694,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-2000',
      NULL,
      '10-27-1992',
      NULL);
commit;
end;
/


