set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1013',
      NULL,
      NULL,
      '30313231',
      '24024443',
      NULL,
      '33144021',
      '11110112',
      '44020431',
      '13411044',
      '03242241',
      '21324020',
      NULL,
      '13324243',
      '03110324',
      '14142140',
      NULL,
      NULL,
      '31442004',
      '40021332',
      '32031323',
      NULL,
      '33042110',
      '30310344',
      NULL,
      '01021101',
      '00431244',
      '42124231',
      '41222110',
      '04041231',
      '24422232',
      '04021301',
      '00303244',
      '04231034',
      '10030400',
      NULL,
      NULL,
      NULL,
      '40402140',
      NULL,
      NULL,
      '02304102',
      '42132413',
      '40000031',
      '42113103',
      '242',
      '41',
      NULL,
      NULL,
      '3343323',
      0.695781,
      1,
      2,
      NULL,
      '220402',
      2,
      ' 9-15-1974',
      NULL,
      12.264831,
      NULL,
      42,
      13,
      NULL,
      12.514055,
      108.613632,
      1.804717,
      18.729141,
      NULL,
      9.413561,
      NULL,
      7,
      21,
      31,
      11,
      10.163528,
      5.124267,
      52.893292,
      NULL,
      17,
      11.115339,
      107,
      12.726073,
      0.282296,
      139.678593,
      44,
      NULL,
      119,
      240,
      60,
      ' 7-18-2003',
      59,
      22.235566,
      31,
      NULL,
      89.946233,
      192,
      '10-10-1975',
      NULL,
      0,
      0,
      1,
      1.779134,
      0.949062,
      1,
      1,
      1,
      1,
      1.241776,
      0.294758,
      1.546737,
      NULL,
      0.997306,
      0.766824,
      1,
      0.699951,
      NULL,
      0.580976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.722578,
      14.882570,
      1,
      11,
      9.443129,
      2,
      '10-22-2002',
      1.342309,
      1.799530,
      NULL,
      0,
      1.646027,
      NULL,
      NULL,
      0,
      16.345257,
      1.866127,
      1.238085,
      50.781295,
      NULL,
      27,
      57.341756,
      1.454595,
      22.789381,
      NULL,
      75.973628,
      NULL,
      79.209822,
      NULL,
      75,
      NULL,
      15,
      ' 8-16-1975',
      2,
      18.772314,
      6,
      20,
      58.338673,
      NULL,
      5,
      ' 3- 6-1982',
      NULL,
      6.888463,
      ' 2-21-1994',
      6,
      NULL,
      NULL,
      2.897330,
      11.122414,
      13,
      NULL,
      7,
      1,
      92.972842,
      0.000675,
      0,
      9,
      0,
      1.041918,
      0.451969,
      0,
      0.939043,
      NULL,
      0,
      0,
      4,
      '10- 4-2003',
      35,
      1,
      ' 2-29-1977',
      44,
      NULL,
      ' 4-10-1976',
      NULL,
      ' 2-18-1988',
      22,
      ' 2-19-2003',
      17,
      NULL,
      ' 3-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037750,
      3.028530,
      ' 0- 6-1986',
      0,
      1,
      9,
      '10- 8-1984',
      42.440464,
      20,
      NULL,
      ' 1-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


